/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype;

import com.numericalmethod.suanshu.algebra.linear.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixAccess;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultMatrixStorage
implements MatrixAccess {
    private final MatrixAccess enum;

    public Vector getRow(int i) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i);
        DenseVector a2 = new DenseVector(this.nCols());
        for (int a3 = 1; a3 <= a2.size(); ++a3) {
            a2.set(a3, this.get(i, a3));
        }
        return a2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultMatrixStorage a2 = (DefaultMatrixStorage)obj;
        return this.enum == a2.enum || this.enum != null && DefaultMatrixStorage.do(this.enum, a2.enum);
    }

    public String toString() {
        int a2;
        int a3 = this.nRows();
        int a4 = this.nCols();
        StringBuilder a5 = new StringBuilder();
        a5.append(String.format("%dx%d\n", this.nRows(), this.nCols()));
        a5.append("\t");
        for (a2 = 1; a2 <= a4; ++a2) {
            a5.append(String.format("[,%d] ", a2));
        }
        a5.append("\n");
        for (a2 = 1; a2 <= a3; ++a2) {
            a5.append(String.format("[%d,] ", a2));
            for (int a6 = 1; a6 <= a4; ++a6) {
                a5.append(String.format("%f, ", this.get(a2, a6)));
            }
            if (a2 == a3) continue;
            a5.append("\n");
        }
        return a5.toString();
    }

    public DefaultMatrixStorage(MatrixAccess storage) {
        this.enum = storage;
    }

    public void setRow(int i, double ... values) {
        DimensionCheck.throwIfInvalidRow(this, i);
        if (values.length != this.nCols()) {
            throw new MatrixAccessException(String.format("the number of values (%d) does not match the column size (%d)", values.length, this.nCols()));
        }
        for (int a2 = 1; a2 <= values.length; ++a2) {
            this.set(i, a2, values[a2 - 1]);
        }
    }

    public void setRow(int i, Vector v) {
        DimensionCheck.throwIfInvalidRow(this, i);
        int a2 = v.size();
        if (a2 != this.nCols()) {
            throw new MatrixAccessException(String.format("the number of values (%d) does not match the column size (%d)", a2, this.nCols()));
        }
        for (int a3 = 1; a3 <= a2; ++a3) {
            this.set(i, a3, v.get(a3));
        }
    }

    public Vector getColumn(int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        DenseVector a2 = new DenseVector(this.nRows());
        for (int a3 = 1; a3 <= a2.size(); ++a3) {
            a2.set(a3, this.get(a3, j2));
        }
        return a2;
    }

    private static boolean do(MatrixAccess a2, MatrixAccess a3) {
        if (a2.nRows() != a3.nRows()) {
            return false;
        }
        if (a2.nCols() != a3.nCols()) {
            return false;
        }
        int a4 = a2.nRows();
        int a5 = a2.nCols();
        for (int a6 = 1; a6 <= a4; ++a6) {
            for (int a7 = 1; a7 <= a5; ++a7) {
                if (DoubleUtils.compare(a2.get(a6, a7), a3.get(a6, a7), 0.0) == 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void set(int row, int col, double value) throws MatrixAccessException {
        this.enum.set(row, col, value);
    }

    public void setColumn(int j2, Vector v) {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        int a2 = v.size();
        if (a2 != this.nRows()) {
            throw new MatrixAccessException(String.format("the number of values (%d) does not match the row size (%d)", a2, this.nRows()));
        }
        for (int a3 = 1; a3 <= a2; ++a3) {
            this.set(a3, j2, v.get(a3));
        }
    }

    @Override
    public int nRows() {
        return this.enum.nRows();
    }

    @Override
    public double get(int row, int col) throws MatrixAccessException {
        return this.enum.get(row, col);
    }

    static {
        Package.validate("BASIC");
    }

    @Override
    public int nCols() {
        return this.enum.nCols();
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 67 * a2 + (this.enum != null ? this.enum.hashCode() : 0);
        return a2;
    }

    public void setColumn(int j2, double ... values) {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        if (values.length != this.nRows()) {
            throw new MatrixAccessException(String.format("the number of values (%d) does not match the row size (%d)", values.length, this.nRows()));
        }
        for (int a2 = 1; a2 <= values.length; ++a2) {
            this.set(a2, j2, values[a2 - 1]);
        }
    }
}

