/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalData;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalDataMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.TridiagonalMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import com.numericalmethod.suanshu.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BidiagonalMatrix
extends DiagonalDataMatrix {
    public BidiagonalMatrix(int dim, BidiagonalMatrixType type) {
        this(BidiagonalMatrix.do(dim, type));
    }

    @Override
    public BidiagonalMatrix ONE() {
        double[] a2 = DoubleUtils.rep(1.0, this.storage.dim);
        return new BidiagonalMatrix(new double[][]{null, a2});
    }

    public boolean isUnreduced(double epsilon) {
        int a2;
        double[] a3 = this.storage.getDiagonal();
        for (a2 = 0; a2 < a3.length; ++a2) {
            if (DoubleUtils.compare(a3[a2], 0.0, epsilon) != 0) continue;
            return false;
        }
        a3 = this.getSuperDiagonal().toArray();
        for (a2 = 0; a2 < a3.length; ++a2) {
            if (DoubleUtils.compare(a3[a2], 0.0, epsilon) != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public BidiagonalMatrix t() {
        double[][] a2 = new double[2][];
        if (this.getType() == BidiagonalMatrixType.UPPER) {
            a2[0] = this.storage.getDiagonal();
            a2[1] = this.storage.getSuperDiagonal();
        } else {
            a2[0] = this.storage.getSubDiagonal();
            a2[1] = this.storage.getDiagonal();
        }
        BidiagonalMatrix a3 = new BidiagonalMatrix(a2);
        return a3;
    }

    @Override
    public Matrix multiply(Matrix that) {
        if (that instanceof BidiagonalMatrix && this.getType() != ((BidiagonalMatrix)that).getType()) {
            BidiagonalMatrix a2 = (BidiagonalMatrix)that;
            DimensionCheck.throwIfDifferentDimension(this, a2);
            int a3 = this.storage.dim;
            if (a3 == 1) {
                double a4 = this.get(1, 1) * that.get(1, 1);
                TridiagonalMatrix a5 = new TridiagonalMatrix(1);
                a5.set(1, 1, a4);
                return a5;
            }
            double[] a6 = new double[a3 - 1];
            double[] a7 = new double[a3];
            double[] a8 = new double[a3 - 1];
            Vector a9 = this.getRow(1);
            Vector a10 = a2.getColumn(1);
            a7[0] = a9.innerProduct(a10);
            a10 = a2.getColumn(2);
            a6[0] = a9.innerProduct(a10);
            for (int a11 = 2; a11 < a3; ++a11) {
                a9 = this.getRow(a11);
                a10 = a2.getColumn(a11 - 1);
                a8[a11 - 2] = a9.innerProduct(a10);
                a10 = a2.getColumn(a11);
                a7[a11 - 1] = a9.innerProduct(a10);
                a10 = a2.getColumn(a11 + 1);
                a6[a11 - 1] = a9.innerProduct(a10);
            }
            a9 = this.getRow(a3);
            a10 = a2.getColumn(a3);
            a7[a3 - 1] = a9.innerProduct(a10);
            a10 = a2.getColumn(a3 - 1);
            a8[a3 - 2] = a9.innerProduct(a10);
            return new TridiagonalMatrix(new double[][]{a6, a7, a8});
        }
        return super.multiply(that);
    }

    @Override
    public BidiagonalMatrix scaled(double c2) {
        return new BidiagonalMatrix(this.storage.scaled(c2));
    }

    public BidiagonalMatrix(double[][] data) {
        this(BidiagonalMatrix.do(data));
    }

    @Override
    public BidiagonalMatrix opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public BidiagonalMatrix ZERO() {
        return new BidiagonalMatrix(this.storage.dim, BidiagonalMatrixType.UPPER);
    }

    public BidiagonalMatrix(BidiagonalMatrix that) {
        this(new DiagonalData(that.storage));
    }

    @Override
    public Matrix add(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof BidiagonalMatrix) {
            DiagonalData a2 = this.storage.add(((BidiagonalMatrix)that).storage);
            BidiagonalMatrix a3 = new BidiagonalMatrix(a2);
            return a3;
        }
        return super.add(that);
    }

    private BidiagonalMatrix(DiagonalData a2) {
        super(a2);
        BidiagonalMatrix a3;
    }

    private static DiagonalData do(double[][] a2) {
        if (a2[0] == null || a2[1] == null) {
            double[] a3 = a2[0] == null ? a2[1] : a2[0];
            return new DiagonalData(new double[][]{DoubleUtils.rep(0.0, a3.length - 1), a3});
        }
        return new DiagonalData(a2);
    }

    @Override
    public Matrix minus(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof BidiagonalMatrix) {
            DiagonalData a2 = this.storage.minus(((BidiagonalMatrix)that).storage);
            BidiagonalMatrix a3 = new BidiagonalMatrix(a2);
            return a3;
        }
        return super.minus(that);
    }

    @Override
    public BidiagonalMatrix deepCopy() {
        return new BidiagonalMatrix(this);
    }

    public BidiagonalMatrixType getType() {
        switch (this.storage.type) {
            case BI_DIAGONAL_UPPER: {
                return BidiagonalMatrixType.UPPER;
            }
            case BI_DIAGONAL_LOWER: {
                return BidiagonalMatrixType.LOWER;
            }
        }
        throw new RuntimeException("inconsistent diagonal data");
    }

    private static DiagonalData do(int a2, BidiagonalMatrixType a3) {
        return new DiagonalData(a3 == BidiagonalMatrixType.UPPER ? DiagonalData.Type.BI_DIAGONAL_UPPER : DiagonalData.Type.BI_DIAGONAL_LOWER, a2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum BidiagonalMatrixType {
        UPPER,
        LOWER;


        private BidiagonalMatrixType() {
            BidiagonalMatrixType a2;
        }
    }
}

