/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixAccess;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import com.numericalmethod.suanshu.misc.datastructure.Table;
import com.numericalmethod.suanshu.misc.parallel.LoopBody;
import com.numericalmethod.suanshu.misc.parallel.MultipleExecutionException;
import com.numericalmethod.suanshu.misc.parallel.ParallelExecutor;

class ParallelMatrixMathOperation
implements MatrixMathOperation {
    @Override
    public Matrix scaled(final MatrixAccess A2, final double scalar) {
        final DenseMatrix a2 = new DenseMatrix(A2.nRows(), A2.nCols());
        try {
            ParallelExecutorInstanceHolder.enum.forLoop(1, A2.nRows() + 1, new LoopBody(){

                @Override
                public void run(int i) throws Exception {
                    for (int a22 = 1; a22 <= A2.nCols(); ++a22) {
                        a2.set(i, a22, A2.get(i, a22) * scalar);
                    }
                }
                {
                    5 a22;
                }
            });
        }
        catch (MultipleExecutionException a3) {
            throw new RuntimeException(a3);
        }
        return a2;
    }

    @Override
    public Vector multiply(final MatrixAccess A2, final Vector v) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)A2, v);
        final DenseVector a2 = new DenseVector(A2.nRows());
        try {
            ParallelExecutorInstanceHolder.enum.forLoop(1, a2.size() + 1, new LoopBody(){

                @Override
                public void run(int i) throws Exception {
                    double a22 = 0.0;
                    for (int a3 = 1; a3 <= v.size(); ++a3) {
                        a22 += A2.get(i, a3) * v.get(a3);
                    }
                    a2.set(i, a22);
                }
                {
                    4 a22;
                }
            });
        }
        catch (MultipleExecutionException a3) {
            throw new RuntimeException(a3);
        }
        return a2;
    }

    @Override
    public Matrix multiply(final MatrixAccess A1, final MatrixAccess A2) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)A1, A2);
        final DenseMatrix a2 = new DenseMatrix(A1.nRows(), A2.nCols());
        try {
            ParallelExecutorInstanceHolder.enum.forLoop(1, a2.nCols() + 1, new LoopBody(){
                {
                    3 a22;
                }

                @Override
                public void run(int j2) throws Exception {
                    int a22;
                    DenseVector a3 = new DenseVector(A2.nRows());
                    for (a22 = 1; a22 <= a3.size(); ++a22) {
                        a3.set(a22, A2.get(a22, j2));
                    }
                    for (a22 = 1; a22 <= a2.nRows(); ++a22) {
                        double a4 = 0.0;
                        for (int a5 = 1; a5 <= A1.nCols(); ++a5) {
                            a4 += A1.get(a22, a5) * a3.get(a5);
                        }
                        a2.set(a22, j2, a4);
                    }
                }
            });
        }
        catch (MultipleExecutionException a3) {
            throw new RuntimeException(a3);
        }
        return a2;
    }

    @Override
    public Matrix add(final MatrixAccess A1, final MatrixAccess A2) {
        DimensionCheck.throwIfDifferentDimension(A1, A2);
        final DenseMatrix a2 = new DenseMatrix(A1.nRows(), A1.nCols());
        try {
            ParallelExecutorInstanceHolder.enum.forLoop(1, A1.nRows() + 1, new LoopBody(){
                {
                    1 a22;
                }

                @Override
                public void run(int i) throws Exception {
                    for (int a22 = 1; a22 <= A1.nCols(); ++a22) {
                        a2.set(i, a22, A1.get(i, a22) + A2.get(i, a22));
                    }
                }
            });
        }
        catch (MultipleExecutionException a3) {
            throw new RuntimeException(a3);
        }
        return a2;
    }

    @Override
    public Matrix minus(final MatrixAccess A1, final MatrixAccess A2) {
        DimensionCheck.throwIfDifferentDimension(A1, A2);
        final DenseMatrix a2 = new DenseMatrix(A1.nRows(), A1.nCols());
        try {
            ParallelExecutorInstanceHolder.enum.forLoop(1, A1.nRows() + 1, new LoopBody(){
                {
                    2 a22;
                }

                @Override
                public void run(int i) throws Exception {
                    for (int a22 = 1; a22 <= A1.nCols(); ++a22) {
                        a2.set(i, a22, A1.get(i, a22) - A2.get(i, a22));
                    }
                }
            });
        }
        catch (MultipleExecutionException a3) {
            throw new RuntimeException(a3);
        }
        return a2;
    }

    ParallelMatrixMathOperation() {
        ParallelMatrixMathOperation a2;
    }

    @Override
    public Matrix transpose(final MatrixAccess A2) {
        final DenseMatrix a2 = new DenseMatrix(A2.nCols(), A2.nRows());
        try {
            ParallelExecutorInstanceHolder.enum.forLoop(1, A2.nCols() + 1, new LoopBody(){
                {
                    6 a22;
                }

                @Override
                public void run(int i) throws Exception {
                    for (int a22 = 1; a22 <= A2.nRows(); ++a22) {
                        a2.set(i, a22, A2.get(a22, i));
                    }
                }
            });
        }
        catch (MultipleExecutionException a3) {
            throw new RuntimeException(a3);
        }
        return a2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class ParallelExecutorInstanceHolder {
        private static final ParallelExecutor enum = new ParallelExecutor(ParallelMatrixMathOperation.class.getSimpleName());

        private ParallelExecutorInstanceHolder() {
            ParallelExecutorInstanceHolder a2;
        }
    }
}

