/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixAccess;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrixUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import com.numericalmethod.suanshu.misc.datastructure.Table;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LILSparseMatrix
implements SparseMatrix {
    private final int const;
    private final SparseVector[] case;
    private final int false;
    private static final MatrixMathOperation enum = new AutoParallelMatrixMathOperation();

    @Override
    public int nRows() {
        return this.const;
    }

    @Override
    public List<SparseMatrix.Entry> getEntrytList() {
        ArrayList<SparseMatrix.Entry> a2 = new ArrayList<SparseMatrix.Entry>(this.nNonZeros());
        int a3 = 0;
        for (int a4 = 1; a4 <= this.const; ++a4) {
            for (SparseVector.Entry a5 : this.case[a4 - 1]) {
                a2.add(a3++, new SparseMatrix.Entry(new MatrixCoordinate(a4, a5.index()), a5.value()));
            }
        }
        return a2;
    }

    @Override
    public LILSparseMatrix ONE() {
        int a2 = Math.min(this.const, this.false);
        double[] a3 = DoubleUtils.rep(1.0, a2);
        int[] a4 = DoubleUtils.seq(1, a2);
        int[] a5 = DoubleUtils.seq(1, a2);
        return new LILSparseMatrix(this.const, this.false, a4, a5, a3);
    }

    private LILSparseMatrix byte(LILSparseMatrix a2) {
        LILSparseMatrix a3;
        DimensionCheck.throwIfDifferentDimension(a3, a2);
        SparseVector[] a4 = new SparseVector[a3.const];
        for (int a5 = 0; a5 < a3.const; ++a5) {
            a4[a5] = a3.case[a5].add(a2.case[a5]);
        }
        return new LILSparseMatrix(a4);
    }

    @Override
    public int nCols() {
        return this.false;
    }

    @Override
    public Vector multiply(Vector v) {
        if (v instanceof SparseVector) {
            return this.do((SparseVector)v);
        }
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, v);
        double[] a2 = new double[this.const];
        for (int a3 = 0; a3 < this.const; ++a3) {
            a2[a3] = this.case[a3].innerProduct(v);
        }
        return new DenseVector(a2);
    }

    public String toString() {
        return SparseMatrixUtils.toString(this);
    }

    public LILSparseMatrix(int nRows, int nCols, List<SparseMatrix.Entry> entries) {
        this(nRows, nCols);
        SparseMatrixUtils.sortInRowColumnOrder(entries, nRows, nCols, true, true);
        MatrixCoordinate a2 = null;
        for (SparseMatrix.Entry a3 : entries) {
            MatrixCoordinate a4 = a3.coordinates;
            ArgumentAssertion.assertTrue(a2 == null || !a2.equals(a4), "repeated entry at coordinates %s", a4);
            a2 = a4;
            this.case[a3.coordinates.i - 1].set(a3.coordinates.j, a3.value);
        }
    }

    @Override
    public int nNonZeros() {
        int a2 = 0;
        for (SparseVector a3 : this.case) {
            a2 += a3.nNonZeros();
        }
        return a2;
    }

    @Override
    public LILSparseMatrix deepCopy() {
        return new LILSparseMatrix(this);
    }

    @Override
    public Matrix multiply(Matrix that) {
        if (that instanceof LILSparseMatrix) {
            return this.do((LILSparseMatrix)that);
        }
        return enum.multiply((MatrixAccess)this, that);
    }

    @Override
    public Matrix minus(Matrix that) {
        if (that instanceof LILSparseMatrix) {
            return this.break((LILSparseMatrix)that);
        }
        return enum.minus(this, that);
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 59 * a2 + Arrays.deepHashCode(this.case);
        a2 = 59 * a2 + this.const;
        a2 = 59 * a2 + this.false;
        return a2;
    }

    @Override
    public SparseVector getColumn(int j2) {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        SparseVector a2 = new SparseVector(this.const);
        for (int a3 = 1; a3 <= this.const; ++a3) {
            double a4 = this.get(a3, j2);
            if (Double.compare(0.0, a4) == 0) continue;
            a2.set(a3, a4);
        }
        return a2;
    }

    public LILSparseMatrix(int nRows, int nCols) {
        this.const = nRows;
        this.false = nCols;
        this.case = new SparseVector[nRows];
        for (int a2 = 0; a2 < nRows; ++a2) {
            this.case[a2] = new SparseVector(nCols);
        }
    }

    private LILSparseMatrix(SparseVector[] a2) {
        LILSparseMatrix a3;
        a3.const = a2.length;
        a3.false = a2[0].size();
        a3.case = a2;
    }

    @Override
    public LILSparseMatrix opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public double get(int row, int col) {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        return this.case[row - 1].get(col);
    }

    @Override
    public LILSparseMatrix t() {
        LILSparseMatrix a2 = new LILSparseMatrix(this.false, this.const);
        for (int a3 = 0; a3 < this.const; ++a3) {
            for (SparseVector.Entry a4 : this.case[a3]) {
                a2.set(a4.index(), a3 + 1, a4.value());
            }
        }
        return a2;
    }

    @Override
    public LILSparseMatrix ZERO() {
        return new LILSparseMatrix(this.const, this.false);
    }

    public LILSparseMatrix(int nRows, int nCols, int[] rowIndices, int[] columnIndices, double[] value) {
        this(nRows, nCols);
        ArgumentAssertion.assertTrue(rowIndices.length == columnIndices.length && rowIndices.length == value.length, "input arrays size mismatch", new Object[0]);
        for (int a2 = 0; a2 < value.length; ++a2) {
            this.case[rowIndices[a2] - 1].set(columnIndices[a2], value[a2]);
        }
    }

    @Override
    public SparseVector getRow(int i) {
        DimensionCheck.throwIfInvalidRow(this, i);
        return new SparseVector(this.case[i - 1]);
    }

    @Override
    public LILSparseMatrix scaled(double c2) {
        if (c2 == 0.0) {
            return new LILSparseMatrix(this.const, this.false);
        }
        SparseVector[] a2 = new SparseVector[this.const];
        for (int a3 = 0; a3 < this.const; ++a3) {
            a2[a3] = this.case[a3].scaled(c2);
        }
        return new LILSparseMatrix(a2);
    }

    @Override
    public void set(int row, int col, double value) {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        this.case[row - 1].set(col, value);
    }

    @Override
    public DenseMatrix toDense() {
        Matrix a2 = new DenseMatrix(this.const, this.false).ZERO();
        int a3 = 1;
        for (SparseVector a4 : this.case) {
            for (SparseVector.Entry a5 : a4) {
                ((DenseMatrix)a2).set(a3, a5.index(), a5.value());
            }
            ++a3;
        }
        return a2;
    }

    private SparseVector do(SparseVector a2) {
        LILSparseMatrix a3;
        DimensionCheck.throwIfIncompatible4Multiplication((Table)a3, a2);
        SparseVector a4 = new SparseVector(a3.const);
        double a5 = 0.0;
        for (int a6 = 0; a6 < a3.const; ++a6) {
            a5 = a3.case[a6].innerProduct(a2);
            if (Double.compare(0.0, a5) == 0) continue;
            a4.set(a6 + 1, a5);
        }
        return a4;
    }

    public LILSparseMatrix(LILSparseMatrix that) {
        this(that.const, that.false);
        for (int a2 = 0; a2 < this.const; ++a2) {
            this.case[a2] = new SparseVector(that.case[a2]);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!SparseMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        LILSparseMatrix a2 = (LILSparseMatrix)obj;
        if (this.const != a2.const) {
            return false;
        }
        if (this.false != a2.false) {
            return false;
        }
        return SparseMatrixUtils.equals(this, a2);
    }

    private LILSparseMatrix break(LILSparseMatrix a2) {
        LILSparseMatrix a3;
        DimensionCheck.throwIfDifferentDimension(a3, a2);
        SparseVector[] a4 = new SparseVector[a3.const];
        for (int a5 = 0; a5 < a3.const; ++a5) {
            a4[a5] = a3.case[a5].minus(a2.case[a5]);
        }
        return new LILSparseMatrix(a4);
    }

    private LILSparseMatrix do(LILSparseMatrix a2) {
        LILSparseMatrix a3;
        DimensionCheck.throwIfIncompatible4Multiplication((Table)a3, a2);
        LILSparseMatrix a4 = a2.t();
        SparseVector[] a5 = new SparseVector[a2.false];
        for (int a6 = 0; a6 < a2.false; ++a6) {
            a5[a6] = a3.do(a4.case[a6]);
        }
        return new LILSparseMatrix(a5).t();
    }

    @Override
    public Matrix add(Matrix that) {
        if (that instanceof LILSparseMatrix) {
            return this.byte((LILSparseMatrix)that);
        }
        return enum.add(this, that);
    }
}

