/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.parallel.LoopBody;
import com.numericalmethod.suanshu.misc.parallel.MultipleExecutionException;
import com.numericalmethod.suanshu.misc.parallel.ParallelExecutor;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class SparseMatrixUtils {
    private static final int false = 100000;
    private static final Comparator<SparseMatrix.Entry> enum = new Comparator<SparseMatrix.Entry>(){

        @Override
        public int compare(SparseMatrix.Entry o1, SparseMatrix.Entry o2) {
            return o1.coordinates.j - o2.coordinates.j;
        }
        {
            1 a2;
        }
    };

    public static int[] sortInRowColumnOrder(final SparseMatrix.Entry[] entries, int nRows, final int nCols, final boolean checkRange, final boolean checkDuplicate) {
        final int[] a2 = SparseMatrixUtils.sortInRowOrder(entries, nRows);
        try {
            ParallelExecutor.getSharedInstance().conditionalForLoop(entries.length >= 100000, 1, nRows + 1, new LoopBody(){

                @Override
                public void run(int i) throws Exception {
                    SparseMatrixUtils.do(entries, a2[i - 1], a2[i], nCols, checkRange, checkDuplicate);
                }
                {
                    2 a22;
                }
            });
        }
        catch (MultipleExecutionException a3) {
            for (int a4 = 1; a4 <= nRows; ++a4) {
                SparseMatrixUtils.do(entries, a2[a4 - 1], a2[a4], nCols, checkRange, checkDuplicate);
            }
        }
        return a2;
    }

    private static void do(SparseMatrix.Entry[] a2, int a3, int a4) {
        int a5 = -1;
        for (int a6 = a3; a6 < a4; ++a6) {
            int a7 = a2[a6].coordinates.j;
            if (a7 == a5) {
                throw new IllegalArgumentException(String.format("repeated entry at coordinates %s", a2[a6].coordinates));
            }
            a5 = a7;
        }
    }

    private static void do(SparseMatrix.Entry[] a2, int a3, int a4, int a5) {
        for (int a6 = a3; a6 < a4; ++a6) {
            int a7 = a2[a6].coordinates.j;
            ArgumentAssertion.assertTrue(a7 >= 1 && a7 <= a5, "some entries are out of column range [1, %d]: %d", a5, a7);
        }
    }

    public static String toString(SparseMatrix A2) {
        List<SparseMatrix.Entry> a2 = A2.getEntrytList();
        StringBuilder a3 = new StringBuilder();
        a3.append(A2.nRows()).append("x").append(A2.nCols()).append(" nnz = ").append(A2.nNonZeros()).append("\n");
        for (SparseMatrix.Entry a4 : a2) {
            a3.append("(").append(a4.coordinates.i).append(", ").append(a4.coordinates.j).append("): ").append(a4.value).append("\n");
        }
        return a3.toString();
    }

    public static boolean equals(SparseMatrix A2, SparseMatrix B) {
        if (A2 == null && B == null) {
            return true;
        }
        if (A2 == null && B != null || A2 != null && B == null) {
            return false;
        }
        if (A2.nRows() != B.nRows()) {
            return false;
        }
        if (A2.nCols() != B.nCols()) {
            return false;
        }
        if (A2.nNonZeros() != B.nNonZeros()) {
            return false;
        }
        List<SparseMatrix.Entry> a2 = A2.getEntrytList();
        List<SparseMatrix.Entry> a3 = B.getEntrytList();
        SparseMatrixUtils.sortInRowColumnOrder(a2, A2.nRows(), A2.nCols(), false, false);
        SparseMatrixUtils.sortInRowColumnOrder(a3, B.nRows(), A2.nCols(), false, false);
        ListIterator<SparseMatrix.Entry> a4 = a2.listIterator();
        ListIterator<SparseMatrix.Entry> a5 = a3.listIterator();
        boolean a6 = a4.hasNext();
        boolean a7 = a5.hasNext();
        while (a6 && a7) {
            if (!((SparseMatrix.Entry)a4.next()).equals(a5.next())) {
                return false;
            }
            a6 = a4.hasNext();
            a7 = a5.hasNext();
        }
        return a6 == a7;
    }

    public static int[] countEntriesInEachColumn(List<SparseMatrix.Entry> entries, int nCols) {
        ArgumentAssertion.assertPositive(nCols, "number of columns");
        int[] a2 = new int[nCols + 1];
        try {
            for (SparseMatrix.Entry a3 : entries) {
                int n = a3.coordinates.j;
                a2[n] = a2[n] + 1;
            }
        }
        catch (ArrayIndexOutOfBoundsException a4) {
            throw new IllegalArgumentException(String.format("some entries are out of column range [1, %d]", nCols), a4);
        }
        ArgumentAssertion.assertTrue(a2[0] == 0, "column index starts from 1", new Object[0]);
        return a2;
    }

    private static void do(SparseMatrix.Entry[] a2, int a3, int a4, int a5, boolean a6, boolean a7) {
        Arrays.sort(a2, a3, a4, enum);
        if (a6) {
            SparseMatrixUtils.do(a2, a3, a4, a5);
        }
        if (a7) {
            SparseMatrixUtils.do(a2, a3, a4);
        }
    }

    private static void do(SparseMatrix.Entry[] a2, List<SparseMatrix.Entry> a3) {
        int a4 = a2.length;
        ListIterator<SparseMatrix.Entry> a5 = a3.listIterator();
        for (int a6 = 0; a6 < a4; ++a6) {
            a5.next();
            a5.set(a2[a6]);
        }
    }

    public static int[] sortInRowOrder(SparseMatrix.Entry[] entries, int nRows) {
        int[] a2 = SparseMatrixUtils.countEntriesInEachRow(Arrays.asList(entries), nRows);
        int[] a3 = DoubleUtils.cumsum(a2);
        int[] a4 = (int[])a3.clone();
        int a5 = entries.length;
        int a6 = 1;
        for (int a7 = 0; a7 < a5; ++a7) {
            while (a7 >= a3[a6]) {
                ++a6;
            }
            SparseMatrix.Entry a8 = entries[a7];
            while (a8.coordinates.i != a6) {
                int a9 = a4[a8.coordinates.i - 1];
                int n = a8.coordinates.i - 1;
                a4[n] = a4[n] + 1;
                SparseMatrix.Entry a10 = entries[a9];
                entries[a9] = a8;
                a8 = a10;
            }
            entries[a7] = a8;
        }
        return a3;
    }

    public static int[] sortInColumnOrder(List<SparseMatrix.Entry> entries, int nCols) {
        SparseMatrix.Entry[] a2 = entries.toArray(new SparseMatrix.Entry[entries.size()]);
        int[] a3 = SparseMatrixUtils.sortInColumnOrder(a2, nCols);
        SparseMatrixUtils.do(a2, entries);
        return a3;
    }

    public static int[] sortInRowColumnOrder(List<SparseMatrix.Entry> entries, int nRows, int nCols, boolean checkRange, boolean checkDuplicate) {
        SparseMatrix.Entry[] a2 = entries.toArray(new SparseMatrix.Entry[entries.size()]);
        int[] a3 = SparseMatrixUtils.sortInRowColumnOrder(a2, nRows, nCols, checkRange, checkDuplicate);
        SparseMatrixUtils.do(a2, entries);
        return a3;
    }

    public static int[] sortInColumnOrder(SparseMatrix.Entry[] entries, int nCols) {
        int[] a2 = SparseMatrixUtils.countEntriesInEachColumn(Arrays.asList(entries), nCols);
        int[] a3 = DoubleUtils.cumsum(a2);
        int[] a4 = (int[])a3.clone();
        int a5 = entries.length;
        int a6 = 1;
        for (int a7 = 0; a7 < a5; ++a7) {
            while (a7 >= a3[a6]) {
                ++a6;
            }
            SparseMatrix.Entry a8 = entries[a7];
            while (a8.coordinates.i != a6) {
                int a9 = a4[a8.coordinates.i - 1];
                int n = a8.coordinates.i - 1;
                a4[n] = a4[n] + 1;
                SparseMatrix.Entry a10 = entries[a9];
                entries[a9] = a8;
                a8 = a10;
            }
            entries[a7] = a8;
        }
        return a3;
    }

    public static int[] countEntriesInEachRow(List<SparseMatrix.Entry> entries, int nRows) {
        ArgumentAssertion.assertPositive(nRows, "number of rows");
        int[] a2 = new int[nRows + 1];
        try {
            for (SparseMatrix.Entry a3 : entries) {
                int n = a3.coordinates.i;
                a2[n] = a2[n] + 1;
            }
        }
        catch (ArrayIndexOutOfBoundsException a4) {
            throw new IllegalArgumentException(String.format("some entries are out of row range [1, %d]", nRows), a4);
        }
        ArgumentAssertion.assertTrue(a2[0] == 0, "row index starts from 1", new Object[0]);
        return a2;
    }

    public static int[] sortInRowOrder(List<SparseMatrix.Entry> entries, int nRows) {
        SparseMatrix.Entry[] a2 = entries.toArray(new SparseMatrix.Entry[entries.size()]);
        int[] a3 = SparseMatrixUtils.sortInRowOrder(a2, nRows);
        SparseMatrixUtils.do(a2, entries);
        return a3;
    }

    private SparseMatrixUtils() {
        SparseMatrixUtils a2;
    }
}

