/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.ConvergenceFailure;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeLinearSystemSolver;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.IdentityPreconditioner;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.PreconditionerFactory;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.misc.algorithm.iterative.monitor.IterationMonitor;
import com.numericalmethod.suanshu.misc.algorithm.iterative.monitor.NullMonitor;
import com.numericalmethod.suanshu.misc.algorithm.iterative.tolerance.Tolerance;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BiconjugateGradientStabilizedSolver
implements IterativeLinearSystemSolver {
    private final int const;
    private final Tolerance case;
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final PreconditionerFactory false;
    private final int enum;

    public BiconjugateGradientStabilizedSolver(int maxIteration, Tolerance tolerance) {
        this(new PreconditionerFactory(){
            {
                1 a2;
            }

            @Override
            public Preconditioner newInstance(Matrix A2) {
                return new IdentityPreconditioner();
            }
        }, 50, maxIteration, tolerance);
    }

    public BiconjugateGradientStabilizedSolver(PreconditionerFactory leftPreconditionerFactory, int residualRefreshRate, int maxIteration, Tolerance tolerance) {
        this.false = leftPreconditionerFactory;
        this.enum = residualRefreshRate;
        this.const = maxIteration;
        this.case = tolerance;
    }

    public IterativeLinearSystemSolver.Solution solve(LSProblem problem) throws ConvergenceFailure {
        return this.solve(problem, new NullMonitor<Vector>());
    }

    @Override
    public IterativeLinearSystemSolver.Solution solve(final LSProblem problem, final IterationMonitor<Vector> monitor) throws ConvergenceFailure {
        return new IterativeLinearSystemSolver.Solution(){
            private final Vector goto;
            private Vector catch;
            private double this;
            private double int;
            private int true;
            private boolean do;
            private Vector long;
            private Vector super;
            private double char;
            private final int new;
            private Vector const;
            private Vector case;
            private final Preconditioner false;
            private final Matrix enum;
            {
                2 a2;
                a2.enum = a2.problem.A();
                a2.goto = a2.problem.b();
                a2.new = Math.min(a2.BiconjugateGradientStabilizedSolver.this.const, a2.enum.nCols());
                a2.false = a2.BiconjugateGradientStabilizedSolver.this.false.newInstance(a2.enum);
                a2.char = 1.0;
                a2.int = 1.0;
                a2.this = 1.0;
                a2.true = 0;
            }

            @Override
            public Vector search(Vector ... initials) throws ConvergenceFailure {
                this.setInitials(initials);
                while (this.true < this.new && !this.do) {
                    this.step();
                    ++this.true;
                    this.do |= BiconjugateGradientStabilizedSolver.this.case.isResidualSmall(this.case.norm());
                }
                monitor.addIterate(this.const);
                if (!this.do) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.MAX_ITERATIONS_EXCEEDED, this.new + " iterations exceeded");
                }
                return this.const;
            }

            public void setInitials(Vector ... initials) {
                this.const = initials[0];
                this.case = this.goto.minus(this.enum.multiply(this.const));
                this.long = this.case.deepCopy();
                this.catch = this.const.ZERO();
                this.super = this.const.ZERO();
                this.do = BiconjugateGradientStabilizedSolver.this.case.isResidualSmall(this.case.norm());
            }

            @Override
            public IterationMonitor<Vector> step() throws ConvergenceFailure {
                monitor.addIterate(this.const);
                if (Double.compare(this.this, 0.0) == 0) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.BREAKDOWN, "omega = 0");
                }
                double a2 = this.long.innerProduct(this.case);
                if (Double.compare(a2, 0.0) == 0) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.BREAKDOWN, "<rTilde, r> = 0");
                }
                double a3 = a2 / this.char * (this.int / this.this);
                this.catch = this.case.add(this.catch.minus(this.super.scaled(this.this)).scaled(a3));
                Vector a4 = this.false.solve(this.catch);
                this.super = this.enum.multiply(a4);
                double a5 = this.long.innerProduct(this.super);
                if (Double.compare(a5, 0.0) == 0) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.BREAKDOWN, "<rTilde, v> = 0");
                }
                this.int = a2 / a5;
                Vector a6 = this.case.minus(this.super.scaled(this.int));
                this.do = BiconjugateGradientStabilizedSolver.this.case.isResidualSmall(a6.norm());
                if (this.do) {
                    this.const = this.const.add(a4.scaled(this.int));
                    return monitor;
                }
                Vector a7 = this.false.solve(a6);
                Vector a8 = this.enum.multiply(a7);
                this.this = a8.innerProduct(a6) / a8.innerProduct(a8);
                this.const = this.const.add(a4.scaled(this.int)).add(a7.scaled(this.this));
                this.case = (this.true + 1) % BiconjugateGradientStabilizedSolver.this.enum != 0 ? a6.minus(a8.scaled(this.this)) : this.goto.minus(this.enum.multiply(this.const));
                this.char = a2;
                return monitor;
            }
        };
    }
}

