/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.ConvergenceFailure;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeLinearSystemSolver;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.IdentityPreconditioner;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.PreconditionerFactory;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.misc.algorithm.iterative.monitor.IterationMonitor;
import com.numericalmethod.suanshu.misc.algorithm.iterative.monitor.NullMonitor;
import com.numericalmethod.suanshu.misc.algorithm.iterative.tolerance.Tolerance;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GeneralizedConjugateResidualSolver
implements IterativeLinearSystemSolver {
    private final int const;
    private final PreconditionerFactory case;
    private final int false;
    private final Tolerance enum;

    public GeneralizedConjugateResidualSolver(PreconditionerFactory leftPreconditionerFactory, int m2, int maxIteration, Tolerance tolerance) {
        this.case = leftPreconditionerFactory;
        this.false = m2;
        this.const = maxIteration;
        this.enum = tolerance;
    }

    public GeneralizedConjugateResidualSolver(int maxIteration, Tolerance tolerance) {
        this(Integer.MAX_VALUE, maxIteration, tolerance);
    }

    @Override
    public IterativeLinearSystemSolver.Solution solve(final LSProblem problem, final IterationMonitor<Vector> monitor) throws ConvergenceFailure {
        return new IterativeLinearSystemSolver.Solution(){
            private boolean do;
            private int long;
            private final Matrix super;
            private Vector char;
            private final Vector new;
            private final Preconditioner const;
            private final int case;
            private final int false;
            private Vector enum;

            public void setInitials(Vector ... initials) {
                this.char = initials[0];
                this.enum = this.new.minus(this.super.multiply(this.char));
                this.do = GeneralizedConjugateResidualSolver.this.enum.isResidualSmall(this.enum.norm());
            }

            @Override
            public Vector search(Vector ... initials) throws ConvergenceFailure {
                this.setInitials(initials);
                while (this.long < this.case && !this.do) {
                    this.step();
                    this.do |= GeneralizedConjugateResidualSolver.this.enum.isResidualSmall(this.enum.norm());
                }
                monitor.addIterate(this.char);
                if (!this.do) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.MAX_ITERATIONS_EXCEEDED, this.case + " iterations exceeded");
                }
                return this.char;
            }
            {
                2 a2;
                a2.super = a2.problem.A();
                a2.new = a2.problem.b();
                a2.case = a2.GeneralizedConjugateResidualSolver.this.false >= a2.problem.A().nCols() ? Math.min(a2.problem.getMaxIteration(), a2.problem.A().nCols()) : a2.GeneralizedConjugateResidualSolver.this.const;
                a2.const = a2.GeneralizedConjugateResidualSolver.this.case.newInstance(a2.super);
                a2.false = Math.min(a2.GeneralizedConjugateResidualSolver.this.false, a2.super.nCols());
                a2.long = 0;
            }

            @Override
            public IterationMonitor<Vector> step() throws ConvergenceFailure {
                Vector a2 = this.const.solve(this.enum);
                Vector[] a3 = new Vector[this.false + 1];
                Vector[] a4 = new Vector[this.false];
                double[] a5 = new double[this.false];
                a3[0] = a2.scaled(1.0 / a2.norm());
                int a6 = 1;
                while (a6 <= this.false && this.long < this.case && !this.do) {
                    monitor.addIterate(this.char);
                    Vector a7 = this.super.multiply(a3[a6 - 1]);
                    a4[a6 - 1] = this.const.solve(a7);
                    a5[a6 - 1] = a4[a6 - 1].innerProduct(a4[a6 - 1]);
                    if (Double.compare(a5[a6 - 1], 0.0) == 0) {
                        throw new ConvergenceFailure(ConvergenceFailure.Reason.BREAKDOWN, "<w, w> = 0");
                    }
                    double a8 = this.enum.innerProduct(a4[a6 - 1]) / a5[a6 - 1];
                    this.char = this.char.add(a3[a6 - 1].scaled(a8));
                    this.enum = this.enum.minus(a4[a6 - 1].scaled(a8));
                    Vector a9 = this.super.multiply(this.enum);
                    Vector a10 = this.const.solve(a9);
                    a3[a6] = this.enum;
                    for (int a11 = 0; a11 < a6; ++a11) {
                        double a12 = -a10.innerProduct(a4[a11]) / a5[a11];
                        a3[a6] = a3[a6].add(a3[a11].scaled(a12));
                    }
                    ++a6;
                    ++this.long;
                    this.do = GeneralizedConjugateResidualSolver.this.enum.isResidualSmall(this.enum.norm());
                }
                this.enum = this.new.minus(this.super.multiply(this.char));
                return monitor;
            }
        };
    }

    public GeneralizedConjugateResidualSolver(int m2, int maxIteration, Tolerance tolerance) {
        this(new PreconditionerFactory(){
            {
                1 a2;
            }

            @Override
            public Preconditioner newInstance(Matrix A2) {
                return new IdentityPreconditioner();
            }
        }, m2, maxIteration, tolerance);
    }

    public IterativeLinearSystemSolver.Solution solve(LSProblem problem) throws ConvergenceFailure {
        return this.solve(problem, new NullMonitor<Vector>());
    }
}

