/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.stationary;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.ConvergenceFailure;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeLinearSystemSolver;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.algorithm.iterative.monitor.IterationMonitor;
import com.numericalmethod.suanshu.misc.algorithm.iterative.monitor.NullMonitor;
import com.numericalmethod.suanshu.misc.algorithm.iterative.tolerance.Tolerance;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JacobiSolver
implements IterativeLinearSystemSolver {
    private final int false;
    private final Tolerance enum;

    private static void do(Matrix a2) {
        for (int a3 = 1; a3 <= a2.nCols(); ++a3) {
            if (Double.compare(a2.get(a3, a3), 0.0) != 0) continue;
            throw new IllegalArgumentException("diagonal entries must be non-zero");
        }
    }

    public IterativeLinearSystemSolver.Solution solve(LSProblem problem) throws ConvergenceFailure {
        return this.solve(problem, new NullMonitor<Vector>());
    }

    public JacobiSolver(int maxIteration, Tolerance tolerance) {
        this.false = maxIteration;
        this.enum = tolerance;
    }

    @Override
    public IterativeLinearSystemSolver.Solution solve(final LSProblem problem, final IterationMonitor<Vector> monitor) throws ConvergenceFailure {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(problem.A()), "the matrix A must be square", new Object[0]);
        JacobiSolver.do(problem.A());
        return new IterativeLinearSystemSolver.Solution(){
            private final Vector false;
            private final Matrix enum;
            int count;
            Vector x;
            final int n;
            Vector r;
            boolean isConverged;

            @Override
            public IterationMonitor<Vector> step() throws ConvergenceFailure {
                monitor.addIterate(this.x);
                Vector a2 = new DenseVector(this.n).ZERO();
                for (int a3 = 1; a3 <= this.n; ++a3) {
                    double a4 = 0.0;
                    for (int a5 = 1; a5 <= this.n; ++a5) {
                        if (a5 == a3) continue;
                        a4 += this.enum.get(a3, a5) * this.x.get(a5);
                    }
                    a4 = (this.false.get(a3) - a4) / this.enum.get(a3, a3);
                    a2.set(a3, a4);
                }
                this.x = a2;
                this.r = this.false.minus(this.enum.multiply(this.x));
                return monitor;
            }
            {
                1 a2;
                a2.enum = a2.problem.A();
                a2.false = a2.problem.b();
                a2.n = a2.problem.size();
                a2.count = 0;
            }

            @Override
            public Vector search(Vector ... initials) throws ConvergenceFailure {
                this.setInitials(initials);
                while (this.count < JacobiSolver.this.false && !this.isConverged) {
                    this.step();
                    ++this.count;
                    this.isConverged |= JacobiSolver.this.enum.isResidualSmall(this.r.norm());
                }
                monitor.addIterate(this.x);
                if (!this.isConverged) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.MAX_ITERATIONS_EXCEEDED, JacobiSolver.this.false + " exceeded");
                }
                return this.x;
            }

            public void setInitials(Vector ... initials) {
                this.x = initials[0];
                this.r = this.false.minus(this.enum.multiply(this.x));
                this.isConverged = JacobiSolver.this.enum.isResidualSmall(this.r.norm());
            }
        };
    }
}

