/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.stationary;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SORSweep {
    private final int const;
    private final Vector case;
    private final double false;
    private final Matrix enum;

    public Vector backward(Vector x) {
        Vector a2 = new DenseVector(this.const).ZERO();
        for (int a3 = this.const; a3 >= 1; --a3) {
            int a4;
            double a5 = 0.0;
            for (a4 = 1; a4 < a3; ++a4) {
                a5 += this.enum.get(a3, a4) * x.get(a4);
            }
            for (a4 = a3 + 1; a4 <= this.const; ++a4) {
                a5 += this.enum.get(a3, a4) * a2.get(a4);
            }
            a5 = (this.case.get(a3) - a5) / this.enum.get(a3, a3);
            a5 = x.get(a3) + this.false * (a5 - x.get(a3));
            a2.set(a3, a5);
        }
        return a2;
    }

    public SORSweep(Matrix A2, Vector b2, double omega) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "A must be a square matrix", new Object[0]);
        SORSweep.do(A2);
        this.enum = A2;
        this.case = b2;
        this.const = A2.nCols();
        this.false = omega;
    }

    private static void do(Matrix a2) {
        for (int a3 = 1; a3 <= a2.nCols(); ++a3) {
            if (Double.compare(a2.get(a3, a3), 0.0) != 0) continue;
            throw new IllegalArgumentException("diagonal entries must be non-zero");
        }
    }

    public Vector forward(Vector x) {
        Vector a2 = new DenseVector(this.const).ZERO();
        for (int a3 = 1; a3 <= this.const; ++a3) {
            int a4;
            double a5 = 0.0;
            for (a4 = 1; a4 < a3; ++a4) {
                a5 += this.enum.get(a3, a4) * a2.get(a4);
            }
            for (a4 = a3 + 1; a4 <= this.const; ++a4) {
                a5 += this.enum.get(a3, a4) * x.get(a4);
            }
            a5 = (this.case.get(a3) - a5) / this.enum.get(a3, a3);
            a5 = x.get(a3) + this.false * (a5 - x.get(a3));
            a2.set(a3, a5);
        }
        return a2;
    }
}

