/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation;

import com.numericalmethod.suanshu.algebra.linear.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DiagonalSum
implements Matrix {
    private final Matrix enum;

    public DiagonalSum(Matrix A2, Vector d) {
        this(A2, d.toArray());
    }

    @Override
    public Matrix ZERO() {
        return this.enum.ZERO();
    }

    @Override
    public Vector getRow(int i) throws MatrixAccessException {
        return this.enum.getRow(i);
    }

    @Override
    public Matrix minus(Matrix that) {
        return this.enum.minus(that);
    }

    @Override
    public int nCols() {
        return this.enum.nCols();
    }

    public DiagonalSum(Matrix A2, double[] d) {
        ArgumentAssertion.assertTrue(A2.nCols() == A2.nRows(), "A must be a square matrix", new Object[0]);
        ArgumentAssertion.assertTrue(A2.nCols() == d.length, "A and d dimensions must match", new Object[0]);
        Matrix a2 = A2.deepCopy();
        int a3 = A2.nCols();
        for (int a4 = 1; a4 <= a3; ++a4) {
            double a5 = A2.get(a4, a4) + d[a4 - 1];
            a2.set(a4, a4, a5);
        }
        this.enum = a2;
    }

    public DiagonalSum(Matrix A2, double d) {
        this(A2, DoubleUtils.rep(d, A2.nCols()));
    }

    @Override
    public double get(int i, int j2) throws MatrixAccessException {
        return this.enum.get(i, j2);
    }

    @Override
    public Vector multiply(Vector v) {
        return this.enum.multiply(v);
    }

    @Override
    public Matrix deepCopy() {
        return this.enum.deepCopy();
    }

    @Override
    public void set(int i, int j2, double value) throws MatrixAccessException {
        this.enum.set(i, j2, value);
    }

    @Override
    public Vector getColumn(int j2) throws MatrixAccessException {
        return this.enum.getColumn(j2);
    }

    @Override
    public Matrix ONE() {
        return this.enum.ONE();
    }

    @Override
    public Matrix t() {
        return this.enum.t();
    }

    @Override
    public Matrix opposite() {
        return this.enum.opposite();
    }

    @Override
    public int nRows() {
        return this.enum.nRows();
    }

    @Override
    public Matrix multiply(Matrix that) {
        return this.enum.multiply(that);
    }

    @Override
    public Matrix scaled(double c2) {
        return this.enum.scaled(c2);
    }

    @Override
    public Matrix add(Matrix that) {
        return this.enum.add(that);
    }
}

