/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation;

import com.numericalmethod.suanshu.algebra.linear.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixAccess;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FastKroneckerProduct
implements Matrix {
    private final Matrix case;
    private final Matrix false;
    private static final MatrixMathOperation enum = new AutoParallelMatrixMathOperation();

    @Override
    public Matrix add(Matrix that) {
        return enum.add(this, that);
    }

    public FastKroneckerProduct(Matrix A2, Matrix B) {
        this.false = A2.deepCopy();
        this.case = B.deepCopy();
    }

    @Override
    public FastKroneckerProduct deepCopy() {
        return this;
    }

    @Override
    public int nCols() {
        return this.false.nCols() * this.case.nCols();
    }

    @Override
    public void set(int i, int j2, double value) throws MatrixAccessException {
        throw new MatrixAccessException("this matrix is immutable");
    }

    @Override
    public Matrix t() {
        return enum.transpose(this);
    }

    @Override
    public Matrix scaled(double scalar) {
        return enum.scaled(this, scalar);
    }

    @Override
    public DenseVector getColumn(int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        double[] a2 = new double[this.nRows()];
        for (int a3 = 0; a3 < a2.length; ++a3) {
            a2[a3] = this.get(a3 + 1, j2);
        }
        return new DenseVector(a2);
    }

    @Override
    public DenseMatrix ONE() {
        return new DenseMatrix(this.nRows(), this.nCols()).ONE();
    }

    @Override
    public Matrix multiply(Matrix that) {
        return enum.multiply((MatrixAccess)this, that);
    }

    @Override
    public DenseVector getRow(int i) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i);
        double[] a2 = new double[this.nCols()];
        for (int a3 = 0; a3 < a2.length; ++a3) {
            a2[a3] = this.get(i, a3 + 1);
        }
        return new DenseVector(a2);
    }

    @Override
    public DenseMatrix ZERO() {
        return new DenseMatrix(this.nRows(), this.nCols()).ZERO();
    }

    @Override
    public Matrix opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public int nRows() {
        return this.false.nRows() * this.case.nRows();
    }

    @Override
    public double get(int i, int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i);
        DimensionCheck.throwIfInvalidColumn(this, j2);
        int a2 = i - 1;
        int a3 = j2 - 1;
        int a4 = this.case.nRows();
        int a5 = this.case.nCols();
        return this.false.get(a2 / a4 + 1, a3 / a5 + 1) * this.case.get(a2 % a4 + 1, a3 % a5 + 1);
    }

    @Override
    public Matrix minus(Matrix that) {
        return enum.minus(this, that);
    }

    @Override
    public Vector multiply(Vector v) {
        return enum.multiply((MatrixAccess)this, v);
    }
}

