/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.triangle.LU;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.triangle.cholesky.Chol;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.BackwardSubstitution;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.ForwardSubstitution;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.PermutationMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.operation.Basis;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import com.numericalmethod.suanshu.misc.parallel.LoopBody;
import com.numericalmethod.suanshu.misc.parallel.MultipleExecutionException;
import com.numericalmethod.suanshu.misc.parallel.ParallelExecutor;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.concurrent.ExecutionException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Inverse
extends DenseMatrix {
    public Inverse(Matrix A2) {
        this(A2, PrecisionUtils.autoEpsilon(A2));
    }

    private static Matrix byte(Matrix a2, double a3) {
        try {
            Chol a4 = new Chol(a2, a3);
            LowerTriangularMatrix a5 = a4.L();
            return Inverse.do(a5, a5.t(), a3);
        }
        catch (RuntimeException a6) {
            return Inverse.break(a2, a3);
        }
    }

    private static Matrix do(LowerTriangularMatrix a2, UpperTriangularMatrix a3, PermutationMatrix a4, double a5) {
        int a6 = a4.nRows();
        DenseMatrix a7 = new DenseMatrix(1, a6);
        for (int a8 = 1; a8 <= a6; ++a8) {
            a7.set(1, a8, a8);
        }
        Matrix a9 = a4.rightMultiply(a7);
        int[] a10 = new int[a6 + 1];
        for (int a11 = 1; a11 <= a6; ++a11) {
            a10[(int)Math.round((double)a9.get((int)1, (int)a11))] = a11;
        }
        return Inverse.do(a2, a3, a10, a5);
    }

    private static Matrix break(Matrix a2, double a3) {
        LU a4 = new LU(a2, a3);
        LowerTriangularMatrix a5 = a4.L();
        UpperTriangularMatrix a6 = a4.U();
        PermutationMatrix a7 = a4.P();
        return Inverse.do(a5, a6, a7, a3);
    }

    private static Matrix do(final LowerTriangularMatrix a2, final UpperTriangularMatrix a3, final int[] a4, final double a5) {
        final ForwardSubstitution a6 = new ForwardSubstitution();
        final BackwardSubstitution a7 = new BackwardSubstitution();
        final int a8 = a2.nRows();
        final DenseMatrix a9 = new DenseMatrix(a8, a8);
        try {
            ParallelExecutor.getSharedInstance().forLoop(1, a8 + 1, new LoopBody(){
                {
                    1 a22;
                }

                @Override
                public void run(int j2) throws Exception {
                    Basis a22 = new Basis(a8, j2);
                    Vector a32 = a6.solve(a2, a22, a5);
                    Vector a42 = a7.solve(a3, a32, a5);
                    a9.setColumn(a4[j2], a42);
                }
            });
        }
        catch (MultipleExecutionException a10) {
            for (ExecutionException a11 : a10.getExceptions()) {
                if (a11 == null) continue;
                throw new RuntimeException("failed to compute inverse", a11.getCause());
            }
        }
        return a9;
    }

    private static Matrix do(LowerTriangularMatrix a2, UpperTriangularMatrix a3, double a4) {
        int[] a5 = DoubleUtils.seq(0, a2.nCols());
        return Inverse.do(a2, a3, a5, a4);
    }

    private static Matrix do(Matrix a2, double a3) {
        if (!DimensionCheck.isSquare(a2)) {
            throw new IllegalArgumentException("Inverse applies to square matrix only");
        }
        if (MatrixPropertyUtils.isSymmetric(a2, a3)) {
            return Inverse.byte(a2, a3);
        }
        return Inverse.break(a2, a3);
    }

    public Inverse(Matrix A2, double epsilon) {
        super(Inverse.do(A2, epsilon));
    }
}

