/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixMeasure;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Pow
extends DenseMatrix {
    private final int case;
    private final ImmutableMatrix false;
    private final double enum;

    public double base() {
        return this.enum;
    }

    public Pow(Matrix A2, int n, double base) {
        super(A2.nCols(), A2.nRows());
        ArgumentAssertion.assertPositive(n, "exponent");
        this.enum = base;
        Matrix a2 = A2.ONE();
        Matrix a3 = A2;
        int a4 = 0;
        int a5 = 0;
        int a6 = 0;
        while (n > 0) {
            if ((n & 1) == 1) {
                a2 = a2.multiply(a3);
                a6 += a5;
            }
            while (MatrixMeasure.max(a2) > base) {
                a2 = a2.scaled(1.0 / base);
                ++a4;
            }
            while (MatrixMeasure.max(a3) > base) {
                a3 = a3.scaled(1.0 / base);
                ++a5;
            }
            if ((n >>>= 1) == 0) continue;
            a3 = a3.multiply(a3);
            a5 *= 2;
        }
        this.case = a4 + a6;
        this.false = new ImmutableMatrix(a2.deepCopy());
        a2 = this.false.scaled(Math.pow(this.enum, this.case));
        for (int a7 = 1; a7 <= this.nRows(); ++a7) {
            for (int a8 = 1; a8 <= this.nCols(); ++a8) {
                super.set(a7, a8, a2.get(a7, a8));
            }
        }
    }

    public int scale() {
        return this.case;
    }

    public Pow(Matrix A2, int n) {
        this(A2, n, 1.0E100);
    }

    public ImmutableMatrix B() {
        return this.false;
    }
}

