/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.householder;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.householder.HouseholderContext;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.parallel.LoopBody;
import com.numericalmethod.suanshu.misc.parallel.MultipleExecutionException;
import com.numericalmethod.suanshu.misc.parallel.ParallelExecutor;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HouseholderInPlace {
    private static final PartialColumnReflection long = new PartialColumnReflection();
    private final int super;
    private final List<Householder> char;
    private final int new;
    private final double[][] const;
    private final double case;
    private final List<Householder> false;
    private static final int enum = 100;

    public HouseholderInPlace(int nRows, int nCols) {
        this.const = new double[nCols][nRows];
        int a2 = Math.min(nRows, nCols);
        for (int a3 = 0; a3 < a2; ++a3) {
            this.const[a3][a3] = 1.0;
        }
        this.super = nRows;
        this.new = nCols;
        this.case = 0.0;
        this.char = new ArrayList<Householder>(nCols);
        this.false = new ArrayList<Householder>(nRows);
    }

    public Matrix Vt() {
        int a2;
        double[][] a3 = new double[this.new][this.new];
        for (a2 = 0; a2 < this.new; ++a2) {
            a3[a2][a2] = 1.0;
        }
        a2 = this.new;
        for (int a4 = this.false.size() - 1; a4 >= 0; --a4) {
            Householder a5 = this.false.get(a4);
            a2 = Math.min(a2, a5.case);
            this.do(a3, a5.enum, a5.const, a5.case, a2);
        }
        return new DenseMatrix(a3);
    }

    public HouseholderInPlace(Matrix A2) {
        this(A2, 0.0);
    }

    public void rightReflect(Householder H, int fromRow, int toRow) {
        this.do(H, fromRow - 1, toRow);
    }

    private void break(Householder a2, int a3, int a4) {
        HouseholderInPlace a5;
        a5.do(a5.const, a2.enum, a2.const, a2.case, a3, a4);
        a5.char.add(a2);
    }

    public Householder generateLeftHouseholder(int columnIndex, int firstEntryIndex, int lastEntryIndex) {
        int a2 = firstEntryIndex - 1;
        int a3 = lastEntryIndex;
        int a4 = columnIndex - 1;
        double[] a5 = Arrays.copyOfRange(this.const[a4], a2, a3);
        Householder a6 = this.do(a5, a2);
        return a6;
    }

    public List<Householder> getLeftHouseholders() {
        return Collections.unmodifiableList(this.char);
    }

    private void do(Householder a2, int a3, int a4) {
        HouseholderInPlace a5;
        a5.break(a5.const, a2.enum, a2.const, a2.case, a3, a4);
        a5.false.add(a2);
    }

    public Householder generateAndReflectRows(int firstRowIndex, int lastRowIndex, int firstEntryIndex, int lastEntryIndex) {
        Householder a2 = this.generateRightHouseholder(firstRowIndex, firstEntryIndex, lastEntryIndex);
        int a3 = firstRowIndex - 1;
        this.const[((Householder)a2).case][a3] = a2.false;
        for (int a4 = a2.case + 1; a4 < lastEntryIndex; ++a4) {
            this.const[a4][a3] = 0.0;
        }
        this.do(a2, a3 + 1, lastRowIndex);
        return a2;
    }

    public Matrix getTransformedMatrix() {
        return new DenseMatrix(this.const).t();
    }

    public Householder generateRightHouseholder(int rowIndex, int firstEntryIndex, int lastEntryIndex) {
        int a2 = rowIndex - 1;
        int a3 = firstEntryIndex - 1;
        double[] a4 = HouseholderInPlace.do(this.const, a2, a3, this.new - a3);
        Householder a5 = this.do(a4, a3);
        return a5;
    }

    public void reflect(Householder H, int fromColumn, int toColumn) {
        this.break(H, fromColumn - 1, toColumn);
    }

    private void break(double[][] a2, double[] a3, double a4, int a5, int a6, int a7) {
        HouseholderInPlace a8;
        int a9 = a6;
        int a10 = a7;
        boolean a11 = false;
        a8.do(a2, a3, a4, a9, a10, 0, new PartialRowReflection(a5, a5 + a3.length));
    }

    public Householder generateAndReflectColumns(int firstColumnIndex, int lastColumnIndex, int firstEntryIndex, int lastEntryIndex) {
        Householder a2 = this.generateLeftHouseholder(firstColumnIndex, firstEntryIndex, lastEntryIndex);
        int a3 = firstColumnIndex - 1;
        this.const[a3][((Householder)a2).case] = a2.false;
        Arrays.fill(this.const[a3], a2.case + 1, lastEntryIndex, 0.0);
        this.break(a2, a3 + 1, lastColumnIndex);
        return a2;
    }

    private void do(double[][] a2, double[] a3, double a4, int a5, int a6, int a7) {
        HouseholderInPlace a8;
        a8.do(a2, a3, a4, a6, a7, a5, long);
    }

    private Householder do(double[] a2, int a3) {
        double a4;
        double[] a5;
        HouseholderInPlace a6;
        double a7;
        double a8 = 0.0;
        for (int a9 = 0; a9 < a2.length; ++a9) {
            a8 += a2[a9] * a2[a9];
        }
        double a10 = Math.sqrt(a8);
        double a11 = a2[0];
        double d = a7 = a11 > 0.0 ? -a10 : a10;
        if (!DoubleUtils.isZero(a7, a6.case)) {
            a5 = (double[])a2.clone();
            a5[0] = a5[0] - a7;
            double a12 = a8 - a11 * a11 + a5[0] * a5[0];
            a4 = 2.0 / a12;
        } else {
            a5 = new double[a2.length];
            a4 = 0.0;
        }
        Householder a13 = new Householder(a3, a2, a5, a4, a7);
        return a13;
    }

    private static double[] do(double[][] a2, int a3, int a4, int a5) {
        double[] a6 = new double[a5];
        int a7 = 0;
        int a8 = a4;
        while (a7 < a5) {
            a6[a7] = a2[a8][a3];
            ++a7;
            ++a8;
        }
        return a6;
    }

    public Matrix U() {
        int a2;
        double[][] a3 = new double[this.super][this.super];
        for (a2 = 0; a2 < this.super; ++a2) {
            a3[a2][a2] = 1.0;
        }
        a2 = this.super;
        for (int a4 = this.char.size() - 1; a4 >= 0; --a4) {
            Householder a5 = this.char.get(a4);
            a2 = Math.min(a2, a5.case);
            this.do(a3, a5.enum, a5.const, a5.case, a2);
        }
        return new DenseMatrix(a3);
    }

    public HouseholderInPlace(Matrix A2, double epsilon) {
        this.const = MatrixUtils.to2DArray(A2.t());
        this.super = A2.nRows();
        this.new = A2.nCols();
        this.case = epsilon;
        this.char = new ArrayList<Householder>(this.new);
        this.false = new ArrayList<Householder>(this.super);
    }

    public double get(int i, int j2) {
        return this.const[j2 - 1][i - 1];
    }

    public List<Householder> getRightHouseholders() {
        return Collections.unmodifiableList(this.false);
    }

    private void do(double[][] a2, double[] a3, double a4, int a5, int a6) {
        HouseholderInPlace a7;
        a7.do(a2, a3, a4, a5, a6, a2.length);
    }

    private void do(double[] a2, double[] a3, double a4, int a5) {
        double a6 = 0.0;
        int a7 = a5;
        for (int a8 = 0; a8 < a3.length; ++a8) {
            a6 += a2[a7] * a3[a8];
            ++a7;
        }
        double a22 = a6 * a4;
        int a9 = a5;
        for (int a10 = 0; a10 < a3.length; ++a10) {
            int n = a9++;
            a2[n] = a2[n] - a22 * a3[a10];
        }
    }

    private void do(final double[][] a2, final double[] a3, final double a4, int a5, int a6, final int a7, final PartialReflection a8) {
        try {
            HouseholderInPlace a9;
            ParallelExecutor a10 = ParallelExecutor.getSharedInstance();
            a10.conditionalForLoop(a6 - a5 > 100, a5, a6, new LoopBody(){

                @Override
                public void run(int jj) throws Exception {
                    double[] a22 = a8.getVector(a2, jj);
                    HouseholderInPlace.this.do(a22, a3, a4, a7);
                    a8.setVector(a2, jj, a22);
                }
                {
                    1 a22;
                }
            });
        }
        catch (MultipleExecutionException a11) {
            throw new RuntimeException(a11);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Householder {
        private final double[] new;
        private final double const;
        private final int case;
        private final double false;
        private final double[] enum;

        private Householder(int a2, double[] a3, double[] a4, double a5, double a6) {
            Householder a7;
            a7.case = a2;
            a7.new = a3;
            a7.enum = a4;
            a7.const = a5;
            a7.false = a6;
        }

        public static Householder fromContext(HouseholderContext ctx, int firstEntryIndex) {
            int a2 = firstEntryIndex - 1;
            Householder a3 = new Householder(a2, ctx.generator.toArray(), ctx.v.toArray(), ctx.beta, ctx.lambda);
            return a3;
        }

        public static HouseholderContext toContext(Householder H) {
            return new HouseholderContext(new DenseVector(H.enum), H.const, new DenseVector(H.new), H.false);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class PartialRowReflection
    implements PartialReflection {
        private final int false;
        private final int enum;

        private PartialRowReflection(int a2, int a3) {
            PartialRowReflection a4;
            a4.false = a2;
            a4.enum = a3 - a2;
        }

        @Override
        public double[] getVector(double[][] columns, int i) {
            double[] a2 = HouseholderInPlace.do(columns, i, this.false, this.enum);
            return a2;
        }

        @Override
        public void setVector(double[][] columns, int i, double[] x) {
            int a2 = this.false;
            for (int a3 = 0; a3 < this.enum; ++a3) {
                columns[a2][i] = x[a3];
                ++a2;
            }
        }
    }

    private static class PartialColumnReflection
    implements PartialReflection {
        @Override
        public void setVector(double[][] columns, int i, double[] x) {
        }

        private PartialColumnReflection() {
            PartialColumnReflection a2;
        }

        @Override
        public double[] getVector(double[][] columns, int i) {
            return columns[i];
        }
    }

    private static interface PartialReflection {
        public void setVector(double[][] var1, int var2, double[] var3);

        public double[] getVector(double[][] var1, int var2);
    }
}

