/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.positivedefinite;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.triangle.LDLt;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MatthewsDavies
extends DenseMatrix {
    private final UpperTriangularMatrix const;
    private final DiagonalMatrix case;
    private final DiagonalMatrix false;
    private final LowerTriangularMatrix enum;

    public DiagonalMatrix Dhat() {
        return new DiagonalMatrix(this.case);
    }

    public LowerTriangularMatrix L() {
        return new LowerTriangularMatrix(this.enum);
    }

    public DiagonalMatrix D() {
        return new DiagonalMatrix(this.false);
    }

    public UpperTriangularMatrix Lt() {
        return this.enum.t();
    }

    public MatthewsDavies(Matrix H) {
        super(H.nCols(), H.nRows());
        int a2;
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(H), "H must be a square matrix", new Object[0]);
        double a3 = PrecisionUtils.autoEpsilon(H);
        LDLt a4 = new LDLt(H);
        this.enum = a4.L();
        this.const = a4.Lt();
        this.false = a4.D();
        this.case = new DiagonalMatrix(this.false);
        double a5 = 1.0;
        for (a2 = 1; a2 <= this.case.nRows(); ++a2) {
            double a6 = this.case.get(a2, a2);
            if (!(a6 > a3) || !(a6 < a5)) continue;
            a5 = a6;
        }
        for (a2 = 1; a2 <= this.case.nRows(); ++a2) {
            if (!(this.case.get(a2, a2) <= a3)) continue;
            this.case.set(a2, a2, a5);
        }
        Matrix a7 = this.enum.multiply(this.case).multiply(this.const);
        for (int a8 = 1; a8 <= this.nRows(); ++a8) {
            for (int a9 = 1; a9 <= this.nCols(); ++a9) {
                super.set(a8, a9, a7.get(a8, a9));
            }
        }
    }
}

