/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.VectorMathOperation;
import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.Real;
import com.numericalmethod.suanshu.number.doublearray.DoubleArrayMath;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DenseVector
implements Vector {
    private static final VectorMathOperation case;
    private final int false;
    private double[] enum;

    @Override
    public double get(int i) {
        MatrixPropertyUtils.throwIfInvalidIndex(this, i);
        return this.enum[i - 1];
    }

    @Override
    public DenseVector deepCopy() {
        return new DenseVector(this);
    }

    public DenseVector(int length) {
        this.false = length;
        this.enum = new double[this.false];
    }

    @Override
    public double innerProduct(Vector that) {
        if (that instanceof DenseVector) {
            return this.innerProduct((DenseVector)that);
        }
        return case.innerProduct(this, that);
    }

    @Override
    public double norm() {
        return this.norm(2.0);
    }

    @Override
    public DenseVector pow(final double scalar) {
        double[] a2 = DoubleUtils.foreach(this.enum, new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double x) {
                return Math.pow(x, scalar);
            }
            {
                3 a2;
            }
        });
        return new DenseVector(a2);
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 19 * a2 + this.false;
        a2 = 19 * a2 + Arrays.hashCode(this.enum);
        return a2;
    }

    static {
        Package.validate("BASIC");
        case = new VectorMathOperation();
    }

    @Override
    public double norm(double p) {
        if (p == Double.POSITIVE_INFINITY) {
            return DoubleArrayMath.max(DoubleArrayMath.abs(this.toArray()));
        }
        if (p == Double.NEGATIVE_INFINITY) {
            return DoubleArrayMath.min(DoubleArrayMath.abs(this.toArray()));
        }
        ArgumentAssertion.assertNotLessThan(p, 1.0, "p");
        double a2 = 0.0;
        for (int a3 = 0; a3 < this.false; ++a3) {
            a2 += Math.pow(Math.abs(this.enum[a3]), p);
        }
        a2 = Math.pow(a2, 1.0 / p);
        return a2;
    }

    public DenseVector(Matrix A2) {
        if (A2.nCols() == 1) {
            this.enum = A2.getColumn(1).toArray();
            this.false = this.enum.length;
            return;
        }
        if (A2.nRows() == 1) {
            this.enum = A2.getRow(1).toArray();
            this.false = this.enum.length;
            return;
        }
        throw new IllegalArgumentException("A must be a column or row matrix");
    }

    @Override
    public DenseVector minus(DenseVector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        DenseVector a2 = new DenseVector(this.false);
        for (int a3 = 0; a3 < this.false; ++a3) {
            a2.enum[a3] = this.enum[a3] - that.enum[a3];
        }
        return a2;
    }

    public DenseVector(double ... data) {
        this.false = data.length;
        this.enum = data;
    }

    @Override
    public void set(int i, double value) {
        MatrixPropertyUtils.throwIfInvalidIndex(this, i);
        this.enum[i - 1] = value;
    }

    @Override
    public DenseVector opposite() {
        return this.scaled(-1.0);
    }

    public DenseVector(int[] data) {
        this.false = data.length;
        this.enum = new double[data.length];
        for (int a2 = 0; a2 < data.length; ++a2) {
            this.enum[a2] = data[a2];
        }
    }

    public void set(int from, DenseVector replacement) {
        if (from + replacement.false - 1 > this.false) {
            throw new IllegalArgumentException("the replacement vector length starting from 'from' exceeds the original vector length");
        }
        int a2 = from;
        for (int a3 = 1; a3 <= replacement.false; ++a3) {
            this.set(a2, replacement.get(a3));
            ++a2;
        }
    }

    @Override
    public double angle(Vector that) {
        return case.angle(this, that);
    }

    @Override
    public DenseVector add(final double scalar) {
        double[] a2 = DoubleUtils.foreach(this.enum, new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double x) {
                return x + scalar;
            }
            {
                1 a2;
            }
        });
        return new DenseVector(a2);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vector)) {
            return false;
        }
        Vector a2 = (Vector)obj;
        return MatrixPropertyUtils.areEqual(this, a2, 0.0);
    }

    @Override
    public DenseVector add(DenseVector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        DenseVector a2 = new DenseVector(this.false);
        for (int a3 = 0; a3 < this.false; ++a3) {
            a2.enum[a3] = this.enum[a3] + that.enum[a3];
        }
        return a2;
    }

    @Override
    public Vector divide(Vector that) {
        if (that instanceof DenseVector) {
            return this.divide((DenseVector)that);
        }
        return case.divide(this, that);
    }

    @Override
    public Vector minus(Vector that) {
        if (that instanceof DenseVector) {
            return this.minus((DenseVector)that);
        }
        return case.minus((Vector)this, that);
    }

    public DenseVector(int length, double value) {
        this.false = length;
        this.enum = new double[this.false];
        for (int a2 = 0; a2 < this.enum.length; ++a2) {
            this.enum[a2] = value;
        }
    }

    @Override
    public double[] toArray() {
        double[] a2 = Arrays.copyOf(this.enum, this.enum.length);
        return a2;
    }

    public DenseVector multiply(DenseVector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        double[] a2 = new double[this.false];
        for (int a3 = 0; a3 < this.false; ++a3) {
            a2[a3] = this.get(a3 + 1) * that.get(a3 + 1);
        }
        return new DenseVector(a2);
    }

    public String toString() {
        StringBuilder a2 = new StringBuilder();
        a2.append("[");
        for (int a3 = 0; a3 < this.false; ++a3) {
            a2.append(String.format("%f, ", this.enum[a3]));
        }
        a2.setCharAt(a2.length() - 2, ']');
        return a2.toString();
    }

    public DenseVector(DenseVector vector) {
        this.false = vector.false;
        this.enum = Arrays.copyOf(vector.enum, this.false);
    }

    public DenseVector(Vector v) {
        this.false = v.size();
        this.enum = v.toArray();
    }

    @Override
    public Vector multiply(Vector that) {
        if (that instanceof DenseVector) {
            return this.multiply((DenseVector)that);
        }
        return case.multiply(this, that);
    }

    public DenseVector(Collection<Double> data) {
        this.false = data.size();
        this.enum = new double[this.false];
        Iterator<Double> a2 = data.iterator();
        for (int a3 = 0; a3 < this.false; ++a3) {
            this.enum[a3] = a2.next();
        }
    }

    @Override
    public DenseVector scaled(double c2) {
        DenseVector a2 = new DenseVector(this.false);
        for (int a3 = 0; a3 < this.false; ++a3) {
            a2.enum[a3] = this.enum[a3] * c2;
        }
        return a2;
    }

    @Override
    public int size() {
        return this.false;
    }

    public DenseVector divide(DenseVector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        double[] a2 = new double[this.false];
        for (int a3 = 0; a3 < this.false; ++a3) {
            a2[a3] = this.get(a3 + 1) / that.get(a3 + 1);
        }
        return new DenseVector(a2);
    }

    @Override
    public DenseVector ZERO() {
        return new DenseVector(this.false);
    }

    @Override
    public DenseVector scaled(Real c2) {
        return this.scaled(c2.doubleValue());
    }

    @Override
    public Vector add(Vector that) {
        if (that instanceof DenseVector) {
            return this.add((DenseVector)that);
        }
        return case.add((Vector)this, that);
    }

    @Override
    public DenseVector minus(final double scalar) {
        double[] a2 = DoubleUtils.foreach(this.enum, new AbstractUnivariateRealFunction(){
            {
                2 a2;
            }

            @Override
            public double evaluate(double x) {
                return x - scalar;
            }
        });
        return new DenseVector(a2);
    }

    @Override
    public double innerProduct(DenseVector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        double a2 = FunctionOps.dotProduct(this.enum, that.enum);
        return a2;
    }
}

