/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.curvefit.interpolation;

import com.numericalmethod.suanshu.analysis.curvefit.interpolation.OnlineInterpolator;
import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.StepFunction;
import com.numericalmethod.suanshu.analysis.function.tuple.OrderedPairs;
import com.numericalmethod.suanshu.analysis.function.tuple.PartialFunction;
import com.numericalmethod.suanshu.misc.license.Package;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LinearInterpolator
extends AbstractUnivariateRealFunction
implements OnlineInterpolator {
    private double[] false;
    private double[] enum;

    public LinearInterpolator(OrderedPairs f) {
        this.false = f.x();
        this.enum = f.y();
    }

    @Override
    public void addData(OrderedPairs f) {
        StepFunction a2 = new StepFunction(new PartialFunction(this.false, this.enum));
        a2.add(f);
        this.false = a2.x();
        this.enum = a2.y();
    }

    static {
        Package.validate("BASIC");
    }

    @Override
    public double evaluate(double u) {
        if (u < this.false[0]) {
            throw new RuntimeException(String.format("cannot interpolate smaller than %f", this.false[0]));
        }
        if (u > this.false[this.false.length - 1]) {
            throw new RuntimeException(String.format("cannot interpolate bigger than %f", this.false[this.false.length - 1]));
        }
        int a2 = Arrays.binarySearch(this.false, u);
        if (a2 >= 0) {
            return this.enum[a2];
        }
        int a3 = -(a2 + 1);
        if (a3 == this.false.length - 1) {
            --a3;
        }
        int a4 = a3 + 1;
        double a5 = FunctionOps.linearInterpolate(u, this.false[a3], this.enum[a3], this.false[a4], this.enum[a4]);
        return a5;
    }
}

