/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.curvefit.interpolation.bivariate;

import com.numericalmethod.suanshu.analysis.curvefit.interpolation.bivariate.BivariateGrid;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BivariateArrayGrid
implements BivariateGrid {
    private final double[][] case;
    private final double[] false;
    private final double[] enum;

    static {
        Package.validate("BASIC");
    }

    @Override
    public double z(int i, int j2) {
        return this.case[i][j2];
    }

    @Override
    public int sizeY() {
        return this.false.length;
    }

    @Override
    public int sizeX() {
        return this.enum.length;
    }

    @Override
    public double x(int i) {
        return this.enum[i];
    }

    @Override
    public double[] x() {
        return (double[])this.enum.clone();
    }

    @Override
    public double y(int j2) {
        return this.false[j2];
    }

    @Override
    public double[] y() {
        return (double[])this.false.clone();
    }

    public BivariateArrayGrid(double[][] z, double[] x, double[] y) {
        ArgumentAssertion.assertPositive(x.length, "x.length");
        ArgumentAssertion.assertPositive(y.length, "y.length");
        ArgumentAssertion.assertTrue(x.length == z.length, "dimensions of z and x do not match", new Object[0]);
        ArgumentAssertion.assertTrue(y.length == z[0].length, "dimensions of z and y do not match", new Object[0]);
        this.case = BivariateArrayGrid.do(z);
        this.enum = (double[])x.clone();
        this.false = (double[])y.clone();
    }

    private static double[][] do(double[][] a2) {
        int a3 = a2[0].length;
        double[][] a4 = new double[a2.length][a3];
        for (int a5 = 0; a5 < a2.length; ++a5) {
            ArgumentAssertion.assertTrue(a2[a5].length == a3, "z[%d] has a different length", a2[a5].length);
            a4[a5] = (double[])a2[a5].clone();
        }
        return a4;
    }
}

