/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.curvefit.interpolation.bivariate;

import com.numericalmethod.suanshu.analysis.curvefit.interpolation.bivariate.BicubicInterpolation;
import com.numericalmethod.suanshu.analysis.curvefit.interpolation.bivariate.BivariateGrid;
import com.numericalmethod.suanshu.misc.license.Package;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PartialDerivativesByCenteredDifferencing
implements BicubicInterpolation.PartialDerivatives {
    static {
        Package.validate("BASIC");
    }

    @Override
    public double dxdy(BivariateGrid grid, int i, int j2) {
        int a2 = this.break(i);
        int a3 = this.do(grid, i);
        int a4 = this.do(j2);
        int a5 = this.break(grid, j2);
        double a6 = grid.z(a3, a5) - grid.z(a3, a4) - grid.z(a2, a5) + grid.z(a2, a4);
        double a7 = (grid.x(a3) - grid.x(a2)) * (grid.y(a5) - grid.y(a4));
        return a6 / a7;
    }

    @Override
    public double dx(BivariateGrid grid, int i, int j2) {
        int a2 = this.break(i);
        int a3 = this.do(grid, i);
        double a4 = grid.z(a3, j2) - grid.z(a2, j2);
        double a5 = grid.x(a3) - grid.x(a2);
        return a4 / a5;
    }

    private int break(BivariateGrid a2, int a3) {
        return Math.min(a2.sizeY() - 1, a3 + 1);
    }

    private int break(int a2) {
        return Math.max(0, a2 - 1);
    }

    @Override
    public double dy(BivariateGrid grid, int i, int j2) {
        int a2 = this.do(j2);
        int a3 = this.break(grid, j2);
        double a4 = grid.z(i, a3) - grid.z(i, a2);
        double a5 = grid.y(a3) - grid.y(a2);
        return a4 / a5;
    }

    private int do(BivariateGrid a2, int a3) {
        return Math.min(a2.sizeX() - 1, a3 + 1);
    }

    private int do(int a2) {
        return Math.max(0, a2 - 1);
    }
}

