/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.solver.multistep.adamsbashforthmoulton;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.problem.DerivativeFunction;
import com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.problem.ODE1stOrder;
import com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.solver.ODEIntegrator;
import com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.solver.ODESolution;
import com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.solver.ODESolver;
import com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.solver.multistep.adamsbashforthmoulton.ABMPredictorCorrector;
import com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.solver.rungekutta.RungeKutta2;
import com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.solver.rungekutta.RungeKuttaIntegrator;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AdamsBashforthMoulton
implements ODESolver {
    private final ABMPredictorCorrector case;
    private final ODEIntegrator false;
    private final double enum;

    @Override
    public ODESolution solve(ODE1stOrder ode) {
        int a2;
        Object a3;
        double a4;
        int a5 = this.case.order();
        ArgumentAssertion.assertTrue((double)a5 * this.enum < (a4 = ode.x1() - ode.x0()), "the initialization exhausts the range for the approximation; select a smaller step size or order, or a larger range", new Object[0]);
        int a6 = (int)(a4 / this.enum) + 1;
        double[] a7 = new double[a6];
        Vector[] a8 = new Vector[a6];
        if (a5 > 1) {
            a3 = new double[a5];
            for (a2 = 0; a2 < a5; ++a2) {
                a3[a2] = this.enum * (double)a2;
            }
            System.arraycopy(a3, 0, a7, 0, a5);
            System.arraycopy(this.false.integrate(ode, (double[])a3), 0, a8, 0, a5);
        } else {
            a7[0] = 0.0;
            a8[0] = ode.y0();
        }
        a3 = ode.dy();
        for (a2 = a5 - 1; a2 < a6 - 1; ++a2) {
            Vector a9;
            double[] a10 = AdamsBashforthMoulton.do(a7, a2, a5);
            Vector[] a11 = AdamsBashforthMoulton.do(a8, a2, a5);
            Vector a12 = this.case.predict((DerivativeFunction)a3, this.enum, a10, a11);
            a7[a2 + 1] = a7[a2] + this.enum;
            a8[a2 + 1] = a12;
            a10 = AdamsBashforthMoulton.do(a7, a2 + 1, a5 + 1);
            a11 = AdamsBashforthMoulton.do(a8, a2 + 1, a5 + 1);
            a8[a2 + 1] = a9 = this.case.correct((DerivativeFunction)a3, this.enum, a10, a11);
        }
        return new ODESolution(a7, a8);
    }

    private static double[] do(double[] a2, int a3, int a4) {
        double[] a5 = new double[a4];
        for (int a6 = 0; a6 < a4; ++a6) {
            a5[a6] = a2[a3 - a6];
        }
        return a5;
    }

    static {
        Package.validate("OPDE");
    }

    public AdamsBashforthMoulton(ABMPredictorCorrector predictorCorrector, double stepSize) {
        this(predictorCorrector, stepSize, new RungeKuttaIntegrator(new RungeKutta2()));
    }

    public AdamsBashforthMoulton(ABMPredictorCorrector predictorCorrector, double stepSize, ODEIntegrator integrator) {
        this.case = predictorCorrector;
        this.enum = stepSize;
        this.false = integrator;
    }

    private static Vector[] do(Vector[] a2, int a3, int a4) {
        Vector[] a5 = new Vector[a4];
        for (int a6 = 0; a6 < a4; ++a6) {
            a5[a6] = a2[a3 - a6];
        }
        return a5;
    }
}

