/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.solver.rungekutta;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.problem.ODE1stOrder;
import com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.solver.ODESolution;
import com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.solver.ODESolver;
import com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.solver.rungekutta.RungeKuttaIntegrator;
import com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.solver.rungekutta.RungeKuttaStepper;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RungeKutta
implements ODESolver {
    private final RungeKuttaStepper false;
    private final Step enum;

    @Override
    public ODESolution solve(ODE1stOrder ode) {
        double[] a2 = DoubleUtils.seq(ode.x0(), ode.x1(), this.enum.size(ode.x0(), ode.x1()));
        a2[a2.length - 1] = ode.x1();
        RungeKuttaIntegrator a3 = new RungeKuttaIntegrator(this.false);
        Vector[] a4 = a3.integrate(ode, a2);
        return new ODESolution(a2, a4);
    }

    public RungeKutta(RungeKuttaStepper stepper, final int N) {
        ArgumentAssertion.assertNotLessThan(N, 2, "N");
        this.false = stepper;
        this.enum = new Step(){
            {
                2 a2;
            }

            @Override
            public double size(double x0, double x1) {
                return (x1 - x0) / (double)(N - 1);
            }
        };
    }

    static {
        Package.validate("OPDE");
    }

    public RungeKutta(RungeKuttaStepper stepper, final double h) {
        this.false = stepper;
        this.enum = new Step(){
            {
                1 a2;
            }

            @Override
            public double size(double x0, double x1) {
                return h;
            }
        };
    }

    private static interface Step {
        public double size(double var1, double var3);
    }
}

