/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.solver.rungekutta;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.analysis.differentialequation.UnsatisfiableErrorCriterionException;
import com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.problem.DerivativeFunction;
import com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.problem.ODE1stOrder;
import com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.solver.ODESolution;
import com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.solver.ODESolver;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RungeKuttaFehlberg
implements ODESolver {
    public static final double DEFAULT_SAFETY_FACTOR = 0.8;
    private final double case;
    private final double false;
    private final double enum;

    public RungeKuttaFehlberg(double epsilon, double minStepSize) {
        this(epsilon, minStepSize, 0.8);
    }

    public RungeKuttaFehlberg(double epsilon, double minStepSize, double gamma) {
        ArgumentAssertion.assertRangeLeftOpen(gamma, 0.0, 1.0, "gamma");
        this.false = epsilon;
        this.case = minStepSize;
        this.enum = gamma;
    }

    @Override
    public ODESolution solve(ODE1stOrder ode) {
        ArrayList<Vector> a2 = new ArrayList<Vector>();
        ArrayList<Double> a3 = new ArrayList<Double>();
        double a4 = ode.x0();
        double a5 = ode.x1();
        DerivativeFunction a6 = ode.dy();
        a3.add(a4);
        a2.add(ode.y0());
        double a7 = a5 - a4;
        int a8 = 0;
        while ((Double)a3.get(a8) + this.case < a5) {
            double a9;
            do {
                Vector a10 = (Vector)a2.get(a8);
                double a11 = (Double)a3.get(a8);
                if (a7 > a5 - a11) {
                    a7 = a5 - a11;
                }
                Vector a12 = a6.evaluate(a11, a10);
                Vector a13 = a6.evaluate(a11 + a7 / 4.0, a10.add(a12.scaled(a7 / 4.0)));
                Vector a14 = a6.evaluate(a11 + a7 * 3.0 / 8.0, a10.add(a12.scaled(a7 * 3.0 / 32.0)).add(a13.scaled(a7 * 9.0 / 32.0)));
                Vector a15 = a6.evaluate(a11 + a7 * 12.0 / 13.0, a10.add(a12.scaled(a7 * 1932.0 / 2197.0)).add(a13.scaled(a7 * -7200.0 / 2197.0)).add(a14.scaled(a7 * 7296.0 / 2197.0)));
                Vector a16 = a6.evaluate(a11 + a7, a10.add(a12.scaled(a7 * 439.0 / 216.0)).add(a13.scaled(a7 * -8.0)).add(a14.scaled(a7 * 3680.0 / 513.0)).add(a15.scaled(a7 * -845.0 / 4104.0)));
                Vector a17 = a6.evaluate(a11 + a7 / 2.0, a10.add(a12.scaled(a7 * -8.0 / 27.0)).add(a13.scaled(a7 * 2.0)).add(a14.scaled(a7 * -3544.0 / 2565.0)).add(a15.scaled(a7 * 1859.0 / 4104.0)).add(a16.scaled(a7 * -11.0 / 40.0)));
                Vector a18 = a10.add(a12.scaled(a7 * 16.0 / 135.0)).add(a14.scaled(a7 * 6656.0 / 12825.0)).add(a15.scaled(a7 * 28561.0 / 56430.0)).add(a16.scaled(a7 * -9.0 / 50.0)).add(a17.scaled(a7 * 2.0 / 55.0));
                Vector a19 = a12.scaled(a7 / 360.0).add(a14.scaled(a7 * -128.0 / 4275.0)).add(a15.scaled(a7 * -2197.0 / 75240.0)).add(a16.scaled(a7 / 50.0)).add(a17.scaled(a7 * 2.0 / 55.0));
                a9 = Math.max(1.0, a18.norm()) * this.false / a19.norm();
                if (a9 >= 1.0) {
                    a2.add(a18);
                    a3.add(a11 + a7);
                }
                if (!((a7 *= this.enum * Math.pow(a9, 0.2)) < this.case)) continue;
                if (a9 < 1.0) {
                    throw new UnsatisfiableErrorCriterionException("step size becomes smaller than the lower bound");
                }
                a7 = this.case;
            } while (a9 < 1.0);
            ++a8;
        }
        return new ODESolution(DoubleUtils.collection2DoubleArray(a3), a2.toArray(new Vector[0]));
    }

    static {
        Package.validate("OPDE");
    }
}

