/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentialequation.pde.finitedifference.elliptic.dim2;

import com.numericalmethod.suanshu.analysis.differentialequation.UnsatisfiableErrorCriterionException;
import com.numericalmethod.suanshu.analysis.differentialequation.pde.PDESolver;
import com.numericalmethod.suanshu.analysis.differentialequation.pde.finitedifference.PDESolutionGrid2D;
import com.numericalmethod.suanshu.analysis.differentialequation.pde.finitedifference.elliptic.dim2.PoissonEquation2D;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class IterativeCentralDifference
implements PDESolver {
    private final double false;
    private final int enum;

    public PDESolutionGrid2D solve(PoissonEquation2D pde, final int m2, final int n) {
        int a2;
        int a3;
        int a4;
        ArgumentAssertion.assertGreaterThan(m2, 1, "the number of x-axis grid points");
        ArgumentAssertion.assertGreaterThan(n, 1, "the number of y-axis grid points");
        final double[][] a5 = new double[m2 + 2][n + 2];
        final double[] a6 = DoubleUtils.seq(0.0, pde.a(), m2 + 2);
        final double[] a7 = DoubleUtils.seq(0.0, pde.b(), n + 2);
        double a8 = 0.0;
        int[] a9 = new int[]{0, m2 + 1};
        int a10 = a9.length;
        for (a4 = 0; a4 < a10; ++a4) {
            a3 = a9[a4];
            for (a2 = 0; a2 < n + 2; ++a2) {
                a5[a3][a2] = pde.g(a6[a3], a7[a2]);
                a8 += a5[a3][a2];
            }
        }
        for (int a11 = 1; a11 < m2 + 1; ++a11) {
            int[] a12 = new int[]{0, n + 1};
            a4 = a12.length;
            for (a3 = 0; a3 < a4; ++a3) {
                a2 = a12[a3];
                a5[a11][a2] = pde.g(a6[a11], a7[a2]);
                a8 += a5[a11][a2];
            }
        }
        double a13 = a8 / (2.0 * (double)(m2 + n) - 4.0);
        for (a4 = 1; a4 < m2 + 1; ++a4) {
            for (a3 = 1; a3 < n + 1; ++a3) {
                a5[a4][a3] = a13;
            }
        }
        double a14 = a6[1];
        double a15 = a7[1];
        double a16 = a14 * a14;
        double a17 = a15 * a15;
        double a18 = a16 / a17;
        double a19 = (Math.cos(Math.PI / (double)n) + a18 * Math.cos(Math.PI / (double)m2)) / (1.0 + a18);
        double a20 = 2.0 / (1.0 + Math.sqrt(1.0 - a19 * a19));
        boolean a21 = false;
        for (int a22 = 0; a22 < this.enum; ++a22) {
            double a23 = 0.0;
            for (int a24 = 1; a24 < m2 + 1; ++a24) {
                for (int a25 = 1; a25 < n + 1; ++a25) {
                    double a26 = a17 * (a5[a24 + 1][a25] + a5[a24 - 1][a25]);
                    double a27 = a16 * (a5[a24][a25 + 1] + a5[a24][a25 - 1]);
                    double a28 = a16 * a17 * pde.f((double)a24 * a14, (double)a25 * a15);
                    double a29 = 2.0 * (a16 + a17);
                    double a30 = (a26 + a27 - a28) / a29;
                    double a31 = a5[a24][a25];
                    a5[a24][a25] = (1.0 - a20) * a5[a24][a25] + a20 * a30;
                    a23 = Math.max(a23, Math.abs(a5[a24][a25] - a31));
                }
            }
            if (!(a23 < this.false)) continue;
            a21 = true;
            break;
        }
        if (!a21) {
            throw new UnsatisfiableErrorCriterionException("failed to converge to the given bound within the maximum number of iterations");
        }
        return new PDESolutionGrid2D(){

            @Override
            public int m() {
                return m2;
            }
            {
                1 a2;
            }

            @Override
            public int n() {
                return n;
            }

            @Override
            public double x(int k2) {
                ArgumentAssertion.assertRange(k2, 0, m2 + 1, "k");
                return a6[k2];
            }

            @Override
            public double y(int j2) {
                ArgumentAssertion.assertRange(j2, 0, n + 1, "j");
                return a7[j2];
            }

            @Override
            public double u(int k2, int j2) {
                ArgumentAssertion.assertRange(k2, 0, m2 + 1, "k");
                ArgumentAssertion.assertRange(j2, 0, n + 1, "j");
                return a5[k2][j2];
            }
        };
    }

    static {
        Package.validate("OPDE");
    }

    public IterativeCentralDifference(double errorBound, int maxIterations) {
        this.false = errorBound;
        this.enum = maxIterations;
    }
}

