/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentialequation.pde.finitedifference.hyperbolic.dim1;

import com.numericalmethod.suanshu.analysis.differentialequation.pde.PDE;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WaveEquation1D
implements PDE {
    private final UnivariateRealFunction new;
    private final double const;
    private final double case;
    private final UnivariateRealFunction false;
    private final double enum;

    public WaveEquation1D(double beta, double T2, double a2, UnivariateRealFunction f, UnivariateRealFunction g2) {
        ArgumentAssertion.assertPositive(beta, "beta");
        ArgumentAssertion.assertPositive(T2, "T");
        ArgumentAssertion.assertPositive(a2, "a");
        this.enum = beta;
        this.const = T2;
        this.case = a2;
        this.new = f;
        this.false = g2;
    }

    public double g(double x) {
        ArgumentAssertion.assertRangeOpen(x, 0.0, this.case, "x");
        return this.false.evaluate(x);
    }

    public double a() {
        return this.case;
    }

    public double T() {
        return this.const;
    }

    static {
        Package.validate("OPDE");
    }

    public double f(double x) {
        ArgumentAssertion.assertRangeOpen(x, 0.0, this.case, "x");
        return this.new.evaluate(x);
    }

    public double beta() {
        return this.enum;
    }
}

