/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentialequation.pde.finitedifference.parabolic.dim1.heatequation;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.LUSolver;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.TridiagonalMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.analysis.differentialequation.pde.PDESolver;
import com.numericalmethod.suanshu.analysis.differentialequation.pde.finitedifference.PDESolutionTimeSpaceGrid1D;
import com.numericalmethod.suanshu.analysis.differentialequation.pde.finitedifference.parabolic.dim1.heatequation.HeatEquation1D;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CrankNicolson1D
implements PDESolver {
    private static Vector do(HeatEquation1D a2, double a3, int a4, double a5, double a6, double a7, double a8, double a9, Vector a10, double a11, double a12) {
        DenseVector a13 = new DenseVector(a4);
        double a14 = 2.0 * (1.0 - a3);
        a13.set(1, (a14 + a7 / a5 * a3) * a10.get(1) + a3 * a10.get(2) + a3 * a9 / a5 * (a2.g1(a11) + a2.g1(a12)));
        for (int a15 = 2; a15 < a4; ++a15) {
            a13.set(a15, a3 * a10.get(a15 - 1) + a14 * a10.get(a15) + a3 * a10.get(a15 + 1));
        }
        a13.set(a4, a3 * a10.get(a4 - 1) + (a14 + a8 / a6 * a3) * a10.get(a4) + a3 * a9 / a6 * (a2.g2(a11) + a2.g2(a12)));
        return a13;
    }

    static {
        Package.validate("OPDE");
    }

    private static Matrix do(double a2, int a3, double a4, double a5, double a6, double a7) {
        double[] a8 = new double[a3 - 1];
        Arrays.fill(a8, -a2);
        double[] a9 = new double[a3];
        Arrays.fill(a9, 2.0 * (1.0 + a2));
        a9[0] = a9[0] - a2 * a6 / a4;
        int n = a3 - 1;
        a9[n] = a9[n] - a2 * a7 / a5;
        return new TridiagonalMatrix(new double[][]{a8, a9, a8});
    }

    public PDESolutionTimeSpaceGrid1D solve(HeatEquation1D pde, final int m2, final int n) {
        ArgumentAssertion.assertGreaterThan(m2, 0, "the number of time-axis grid points");
        ArgumentAssertion.assertGreaterThan(n, 0, "the number of space-axis grid points");
        final double[] a2 = DoubleUtils.seq(0.0, pde.T(), m2 + 1);
        final double[] a3 = DoubleUtils.seq(0.0, pde.a(), n + 2);
        final Vector[] a4 = new Vector[m2 + 1];
        double a5 = a3[1];
        double a6 = a2[1];
        double a7 = pde.c1();
        double a8 = pde.c2();
        double a9 = a7 + (1.0 - a7) * a5;
        double a10 = a8 + (1.0 - a8) * a5;
        double a11 = pde.beta() * (a6 / (a5 * a5));
        a4[0] = new DenseVector(n);
        for (int a12 = 1; a12 <= n; ++a12) {
            a4[0].set(a12, pde.f(a3[a12]));
        }
        Matrix a13 = CrankNicolson1D.do(a11, n, a9, a10, a7, a8);
        LUSolver a14 = new LUSolver();
        for (int a15 = 0; a15 < a4.length - 1; ++a15) {
            Vector a16 = CrankNicolson1D.do(pde, a11, n, a9, a10, a7, a8, a5, a4[a15], a2[a15], a2[a15 + 1]);
            LSProblem a17 = new LSProblem(a13, a16);
            a4[a15 + 1] = a14.solve(a17);
        }
        return new PDESolutionTimeSpaceGrid1D(){

            @Override
            public double t(int k2) {
                ArgumentAssertion.assertRange(k2, 0, m2, "k");
                return a2[k2];
            }

            @Override
            public double x(int j2) {
                ArgumentAssertion.assertRange(j2, 0, n + 1, "j");
                return a3[j2];
            }
            {
                1 a22;
            }

            @Override
            public double u(int k2, int j2) {
                ArgumentAssertion.assertRange(k2, 0, m2, "k");
                ArgumentAssertion.assertRange(j2, 0, n + 1, "j");
                if (j2 == 0 || j2 == n + 1) {
                    throw new UnsupportedOperationException("boundary values are not available");
                }
                return a4[k2].get(j2);
            }

            @Override
            public int n() {
                return n;
            }

            @Override
            public int m() {
                return m2;
            }
        };
    }
}

