/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentiation.multivariate;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.analysis.function.rn2r1.AbstractRealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.misc.Constants;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultivariateFiniteDifference
extends AbstractRealScalarFunction {
    private final int[] false;
    private final RealScalarFunction enum;

    @Override
    public Double evaluate(Vector x) {
        double a2 = Math.pow(Constants.MACH_EPS, 1.0 / (double)(this.false.length + 1)) * Math.max(0.1, x.norm());
        return this.evaluate(x, a2);
    }

    public MultivariateFiniteDifference(RealScalarFunction f, int[] varidx) {
        super(f.dimensionOfDomain());
        this.enum = f;
        for (int a2 = 0; a2 < varidx.length; ++a2) {
            if (varidx[a2] >= 1 && varidx[a2] <= f.dimensionOfDomain()) continue;
            throw new IllegalArgumentException("invalid variable specification; order specifiies variable indices");
        }
        this.false = Arrays.copyOf(varidx, varidx.length);
    }

    public double evaluate(Vector x, double h) {
        double a2 = this.do(this.false.length, h, x);
        return a2;
    }

    private double do(int a2, double a3, Vector a4) {
        MultivariateFiniteDifference a5;
        DenseVector a6 = new DenseVector(a4);
        if (a2 == 1) {
            int a7 = a5.false[0];
            a6.set(a7, a4.get(a7) + a3);
            double a8 = (Double)a5.enum.evaluate(a6);
            a6.set(a7, a6.get(a7) - 2.0 * a3);
            double a9 = (Double)a5.enum.evaluate(a6);
            double a10 = (a8 - a9) / 2.0 / a3;
            return a10;
        }
        int a11 = a5.false[a2 - 1];
        a6.set(a11, a4.get(a11) + a3);
        double a12 = a5.do(a2 - 1, a3, a6);
        a6.set(a11, a6.get(a11) - 2.0 * a3);
        double a13 = a5.do(a2 - 1, a3, a6);
        double a14 = (a12 - a13) / 2.0 / a3;
        return a14;
    }
}

