/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentiation.univariate;

import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.Constants;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FiniteDifference
extends AbstractUnivariateRealFunction {
    private volatile double const;
    private final int case;
    private final Type false;
    private final UnivariateRealFunction enum;

    public double df(double x, double h) {
        double a2 = 0.0;
        int a3 = 1;
        for (int a4 = 0; a4 <= this.case; ++a4) {
            double a5 = x;
            switch (this.false) {
                case FORWARD: {
                    a5 += (double)(this.case - a4) * h;
                    break;
                }
                case BACKWARD: {
                    a5 += (double)(-a4) * h;
                    break;
                }
                case CENTRAL: {
                    a5 += ((double)this.case / 2.0 - (double)a4) * h;
                }
            }
            a2 += (double)a3 * FunctionOps.combination(this.case, a4) * this.enum.evaluate(a5);
            a3 *= -1;
        }
        return a2;
    }

    public FiniteDifference(UnivariateRealFunction f, int order, Type type) {
        ArgumentAssertion.assertPositive(order, "the order of derivative");
        this.case = order;
        this.false = type;
        this.enum = f;
    }

    public double evaluate(double x, double h) {
        this.const = x + h;
        h = this.const - x;
        double a2 = this.df(x, h);
        if (this.case % 2 == 1 && this.false == Type.CENTRAL) {
            a2 = 0.5 * (this.df(x - h / 2.0, h) + this.df(x + h / 2.0, h));
        }
        double a3 = a2 / Math.pow(h, this.case);
        return a3;
    }

    @Override
    public double evaluate(double x) {
        double a2 = Math.pow(Constants.MACH_EPS, 1.0 / (double)(this.case + 1)) * Math.max(0.1, Math.abs(x));
        return this.evaluate(x, a2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum Type {
        FORWARD,
        BACKWARD,
        CENTRAL;


        private Type() {
            Type a2;
        }
    }
}

