/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.polynomial;

import com.numericalmethod.suanshu.algebra.structure.Ring;
import com.numericalmethod.suanshu.algebra.structure.VectorSpace;
import com.numericalmethod.suanshu.analysis.function.polynomial.HornerScheme;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.Real;
import com.numericalmethod.suanshu.number.complex.Complex;
import com.numericalmethod.suanshu.number.complex.ElementaryFunction;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Polynomial
extends AbstractUnivariateRealFunction
implements Ring<Polynomial>,
VectorSpace<Polynomial, Real> {
    public static final Polynomial ONE;
    public static final Polynomial ZERO;
    private int false;
    private final double[] enum;

    public String toString() {
        StringBuilder a2 = new StringBuilder();
        for (int a3 = 0; a3 <= this.false; ++a3) {
            if (this.enum[a3] == 0.0) continue;
            if (a3 > 0 && this.enum[a3] >= 0.0) {
                a2.append("+");
            }
            a2.append(String.format("%.2f", this.enum[a3]));
            if (a3 == this.false) continue;
            a2.append(String.format("(x^%d)", this.false - a3));
        }
        return a2.toString();
    }

    static {
        ZERO = new Polynomial(0.0);
        ONE = new Polynomial(1.0);
    }

    public double[] getCoefficients() {
        return Arrays.copyOf(this.enum, this.enum.length);
    }

    public Polynomial(double ... coefficients) {
        this.false = coefficients.length - 1;
        for (int a2 = 0; a2 < coefficients.length - 1 && coefficients[a2] == 0.0; ++a2) {
            --this.false;
        }
        this.enum = Arrays.copyOfRange(coefficients, coefficients.length - this.false - 1, coefficients.length);
    }

    @Override
    public Polynomial ONE() {
        return ONE;
    }

    @Override
    public Polynomial minus(Polynomial that) {
        return this.add(that.opposite());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Polynomial)) {
            return false;
        }
        Polynomial a2 = (Polynomial)obj;
        if (this.false != a2.false) {
            return false;
        }
        return this.enum == a2.enum || this.enum != null && DoubleUtils.equal(this.enum, a2.enum, 0.0);
    }

    @Override
    public Complex evaluate(Complex z) {
        Complex a2 = z.ZERO();
        for (int a3 = 0; a3 <= this.false; ++a3) {
            a2 = a2.add(ElementaryFunction.pow(z, new Complex(this.false - a3, 0.0)).multiply(new Complex(this.enum[a3], 0.0)));
        }
        return a2;
    }

    public Polynomial getNormalization() {
        double[] a2 = Arrays.copyOf(this.enum, this.enum.length);
        double a3 = a2[0];
        int a4 = 1;
        while (a4 < a2.length) {
            int n = a4++;
            a2[n] = a2[n] / a3;
        }
        a2[0] = 1.0;
        return new Polynomial(a2);
    }

    @Override
    public Polynomial opposite() {
        double[] a2 = new double[this.enum.length];
        for (int a3 = 0; a3 <= this.false; ++a3) {
            a2[a3] = -this.enum[a3];
        }
        return new Polynomial(a2);
    }

    @Override
    public double evaluate(double x) {
        if (this.false == 0) {
            return this.enum[0];
        }
        HornerScheme a2 = new HornerScheme(this, x);
        return a2.remainder();
    }

    public int degree() {
        return this.false;
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 71 * a2 + this.false;
        a2 = 71 * a2 + (this.enum != null ? this.enum.hashCode() : 0);
        return a2;
    }

    @Override
    public Polynomial add(Polynomial that) {
        double[] a2;
        double[] a3;
        if (this.false > that.false) {
            a3 = this.enum;
            a2 = that.enum;
        } else {
            a3 = that.enum;
            a2 = this.enum;
        }
        int a4 = a3.length - a2.length;
        double[] a5 = new double[a3.length];
        System.arraycopy(a3, 0, a5, 0, a4);
        for (int a6 = 0; a6 < a2.length; ++a6) {
            a5[a4 + a6] = a3[a4 + a6] + a2[a6];
        }
        return new Polynomial(a5);
    }

    @Override
    public Polynomial ZERO() {
        return ZERO;
    }

    public Polynomial pow(int n) {
        Polynomial a2 = new Polynomial(this);
        for (int a3 = 2; a3 <= n; ++a3) {
            a2 = a2.multiply(this);
        }
        return a2;
    }

    @Override
    public Polynomial scaled(Real c2) {
        return this.scaled(c2.doubleValue());
    }

    @Override
    public Complex evaluate(Number x) {
        if (x instanceof Complex) {
            return this.evaluate((Complex)x);
        }
        double a2 = this.evaluate(x.doubleValue());
        return new Complex(a2, 0.0);
    }

    @Override
    public Polynomial multiply(Polynomial that) {
        int a2 = this.false + that.false;
        double[] a3 = new double[a2 + 1];
        for (int a4 = 0; a4 < a3.length; ++a4) {
            a3[a4] = 0.0;
            for (int a5 = 0; a5 <= a4; ++a5) {
                int n = a4;
                a3[n] = a3[n] + that.getCoefficient(a5) * this.getCoefficient(a4 - a5);
            }
        }
        return new Polynomial(a3);
    }

    public Polynomial(Polynomial that) {
        this(that.getCoefficients());
    }

    @Override
    public Polynomial scaled(double c2) {
        double[] a2 = new double[this.enum.length];
        for (int a3 = 0; a3 < a2.length; ++a3) {
            a2[a3] = c2 * this.enum[a3];
        }
        return new Polynomial(a2);
    }

    public double getCoefficient(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("coefficient index counts from 0, the highest order term");
        }
        return i < this.enum.length ? this.enum[i] : 0.0;
    }
}

