/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.polynomial.root;

import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.PolyRootSolver;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.complex.Complex;
import java.util.ArrayList;
import java.util.List;

public class QuadraticRoot
implements PolyRootSolver {
    public List<Number> solve(Polynomial polynomial, double epsilon) {
        ArgumentAssertion.assertEqual(polynomial.degree(), 2, "polynomial degree");
        ArrayList<Number> a2 = new ArrayList<Number>();
        double[] a3 = polynomial.getCoefficients();
        double a4 = a3[0];
        double a5 = a3[1];
        double a6 = a3[2];
        if (DoubleUtils.isZero(a6, epsilon)) {
            a2.add(new Double(0.0));
            a2.add(new Double(-a5 / a4));
            return a2;
        }
        if (DoubleUtils.isZero(a5, epsilon)) {
            double a7 = a6 / a4;
            if (a7 < 0.0) {
                double a8 = Math.sqrt(-a7);
                a2.add(new Double(a8));
                a2.add(new Double(-a8));
                return a2;
            }
            double a9 = Math.sqrt(a7);
            a2.add(new Complex(0.0, a9));
            a2.add(new Complex(0.0, -a9));
            return a2;
        }
        double a10 = a5 / 2.0;
        double a11 = 0.0;
        double a12 = 0.0;
        if (Math.abs(a10) < Math.abs(a6)) {
            a12 = Math.signum(a6) * a4;
            a12 = -a12 + a10 * (a10 / Math.abs(a6));
            a11 = Math.sqrt(Math.abs(a12)) * Math.sqrt(Math.abs(a6));
        } else {
            a12 = 1.0 - a4 / a10 * (a6 / a10);
            a11 = Math.sqrt(Math.abs(a12)) * Math.abs(a10);
        }
        if (DoubleUtils.compare(a12, 0.0, epsilon) >= 0) {
            a11 = -Math.signum(a10) * a11;
            double a13 = (-a10 + a11) / a4;
            a2.add(a13);
            a2.add(!DoubleUtils.isZero(a13, 0.0) ? a6 / a13 / a4 : 0.0);
        } else {
            double a14 = -(a10 / a4);
            double a15 = a11 / a4;
            a2.add(new Complex(a14, a15));
            a2.add(new Complex(a14, -a15));
        }
        return a2;
    }

    public List<Number> solve(Polynomial polynomial) {
        ArgumentAssertion.assertEqual(polynomial.degree(), 2, "polynomial degree");
        double[] a2 = polynomial.getCoefficients();
        double a3 = a2[0];
        double a4 = a2[1];
        double a5 = a2[2];
        double a6 = PrecisionUtils.autoEpsilon(a3, a4, a5);
        return this.solve(polynomial, a6);
    }
}

