/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.rn2r1.univariate;

import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.tuple.DuplicatedAbscissae;
import com.numericalmethod.suanshu.analysis.function.tuple.OrderedPairs;
import com.numericalmethod.suanshu.analysis.function.tuple.Pair;
import com.numericalmethod.suanshu.analysis.function.tuple.PairComparatorByAbscissaOnly;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import java.util.TreeSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StepFunction
extends AbstractUnivariateRealFunction
implements OrderedPairs {
    private final TreeSet<Pair> enum;

    public StepFunction(OrderedPairs f) {
        this(f, 0.0);
    }

    @Override
    public double[] y() {
        double[] a2 = new double[this.enum.size()];
        int a3 = 0;
        for (Pair a4 : this.enum) {
            a2[a3] = a4.y();
            ++a3;
        }
        return a2;
    }

    public double maxDomain() {
        return this.enum.last().x();
    }

    @Override
    public double[] x() {
        double[] a2 = new double[this.enum.size()];
        int a3 = 0;
        for (Pair a4 : this.enum) {
            a2[a3] = a4.x();
            ++a3;
        }
        return a2;
    }

    public StepFunction(OrderedPairs f, double epsilon) {
        this(epsilon);
        this.add(f);
    }

    public void add(OrderedPairs f) {
        double[] a2 = f.x();
        double[] a3 = f.y();
        ArgumentAssertion.assertEqual(a2.length, a3.length, "x's length", "y's length");
        for (int a4 = 0; a4 < a2.length; ++a4) {
            Pair a5 = new Pair(a2[a4], a3[a4]);
            if (this.enum.add(a5)) continue;
            throw new DuplicatedAbscissae(String.format("x[%d] are duplicated", a4));
        }
    }

    @Override
    public double evaluate(double x) {
        Pair a2 = this.enum.floor(new Pair(x, 0.0));
        if (a2 != null) {
            return a2.y();
        }
        throw new RuntimeException(String.format("f(%f) is not defined", x));
    }

    public double minDomain() {
        return this.enum.first().x();
    }

    public StepFunction(double epsilon) {
        this.enum = new TreeSet<Pair>(new PairComparatorByAbscissaOnly(epsilon));
    }

    @Override
    public int size() {
        return this.enum.size();
    }
}

