/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.special.gamma;

import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.special.gamma.Gamma;
import com.numericalmethod.suanshu.analysis.function.special.gamma.Lanczos;
import com.numericalmethod.suanshu.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GammaLanczosQuick
extends AbstractUnivariateRealFunction
implements Gamma {
    private final Lanczos enum;

    @Override
    public double evaluate(double x) {
        if (DoubleUtils.isZero(x, 0.0)) {
            return Double.POSITIVE_INFINITY;
        }
        double a2 = x > 0.0 ? x : -x;
        double a3 = this.enum.logGammaQuick(a2);
        a3 = Math.exp(a3);
        a3 = x > 0.0 ? a3 : GammaLanczosQuick.reflectionFormula(-x, a3);
        return a3;
    }

    public GammaLanczosQuick(double g2, int n, int scale) {
        this.enum = new Lanczos(g2, n, scale);
    }

    static double reflectionFormula(double a2, double a3) {
        double a4 = Math.PI / a2;
        a4 /= a3;
        return a4 /= Math.sin(-a2 * Math.PI);
    }

    public GammaLanczosQuick() {
        this.enum = new Lanczos();
    }
}

