/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann.gaussian.rule;

import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.gaussian.rule.GaussianQuadratureRule;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ChebyshevRule
implements GaussianQuadratureRule {
    private final int enum;

    @Override
    public boolean supportsInterval(double a2, double b2) {
        return a2 == -1.0 && b2 == 1.0;
    }

    @Override
    public double[] getCoefficients() {
        double[] a2 = DoubleUtils.rep(Math.PI / (double)this.enum, this.enum);
        return a2;
    }

    public ChebyshevRule(int n) {
        this.enum = n;
    }

    @Override
    public double[] getEvaluationPoints() {
        double[] a2 = new double[this.enum];
        for (int a3 = 1; a3 <= this.enum; ++a3) {
            a2[a3 - 1] = Math.cos((2.0 * (double)a3 - 1.0) * Math.PI / (2.0 * (double)this.enum));
        }
        Arrays.sort(a2);
        return a2;
    }

    @Override
    public double getWeighting(double x) {
        return 1.0 / Math.sqrt(1.0 - x * x);
    }
}

