/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann.gaussian.rule;

import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.gaussian.rule.OrthogonalPolynomialFamily;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;

public class HermitePolynomials
implements OrthogonalPolynomialFamily {
    @Override
    public Polynomial getPolynomial(int order) {
        ArgumentAssertion.assertNonNegative(order, "the order of the Hermite Polynomial");
        if (order == 0) {
            return Polynomial.ONE;
        }
        Polynomial a2 = new Polynomial(1.0, 0.0);
        Polynomial a3 = a2.scaled(2.0);
        if (order == 1) {
            return a3;
        }
        Polynomial[] a4 = new Polynomial[order + 1];
        a4[0] = Polynomial.ONE;
        a4[1] = a3;
        for (int a5 = 2; a5 <= order; ++a5) {
            Polynomial a6 = a4[a5 - 1].multiply(a3);
            Polynomial a7 = a4[a5 - 2].scaled(2.0 * (double)(a5 - 1));
            a4[a5] = a6.minus(a7);
        }
        return a4[a4.length - 1];
    }
}

