/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann.gaussian.rule;

import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.gaussian.rule.GaussianQuadratureRule;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.gaussian.rule.GaussianQuadratureUtils;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.gaussian.rule.HermitePolynomials;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HermiteRule
implements GaussianQuadratureRule {
    private final double[] false;
    private final double[] enum;

    @Override
    public boolean supportsInterval(double a2, double b2) {
        return Double.isInfinite(a2) && a2 < 0.0 && Double.isInfinite(b2) && b2 > 0.0;
    }

    @Override
    public double getWeighting(double x) {
        return Math.exp(-(x * x));
    }

    private static double[] do(int a2) {
        Polynomial a3 = new HermitePolynomials().getPolynomial(a2);
        return GaussianQuadratureUtils.solveForEvaluationPointsFromPolynomial(a3);
    }

    private static double[] do(int a2, double[] a3) {
        Polynomial a4 = new HermitePolynomials().getPolynomial(a2 - 1);
        double[] a5 = new double[a2];
        double a6 = (double)(1 << a2 - 1) * FunctionOps.factorial(a2) * Math.sqrt(Math.PI) / (double)(a2 * a2);
        for (int a7 = 1; a7 <= a2; ++a7) {
            double a8 = a4.evaluate(a3[a7 - 1]);
            double a9 = a8 * a8;
            a5[a7 - 1] = a6 / a9;
        }
        return a5;
    }

    public HermiteRule(int n) {
        this.false = HermiteRule.do(n);
        this.enum = HermiteRule.do(n, this.false);
    }

    @Override
    public double[] getEvaluationPoints() {
        return Arrays.copyOf(this.false, this.false.length);
    }

    @Override
    public double[] getCoefficients() {
        return Arrays.copyOf(this.enum, this.enum.length);
    }
}

