/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann.gaussian.rule;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.LinearSystemSolver;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.gaussian.rule.GaussianQuadratureRule;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.gaussian.rule.GaussianQuadratureUtils;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.gaussian.rule.LaguerrePolynomials;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LaguerreRule
implements GaussianQuadratureRule {
    private final double[] false;
    private final double[] enum;

    @Override
    public double[] getEvaluationPoints() {
        return Arrays.copyOf(this.enum, this.enum.length);
    }

    @Override
    public double getWeighting(double x) {
        return Math.exp(-x);
    }

    @Override
    public boolean supportsInterval(double a2, double b2) {
        return a2 == 0.0 && b2 == Double.POSITIVE_INFINITY;
    }

    private static double[] do(double[] a2, double a3) {
        int a4 = a2.length;
        DenseVector a5 = new DenseVector(a4);
        DenseMatrix a6 = new DenseMatrix(a4, a4);
        for (int a7 = 0; a7 < a4; ++a7) {
            a5.set(a7 + 1, FunctionOps.factorial(2 * a7));
            for (int a8 = 0; a8 < a4; ++a8) {
                a6.set(a7 + 1, a8 + 1, Math.pow(a2[a8], 2 * a7));
            }
        }
        Vector a9 = new LinearSystemSolver(a3).solve(a6).getParticularSolution(a5);
        return a9.toArray();
    }

    public LaguerreRule(int n, double precision) {
        this.enum = LaguerreRule.do(n);
        this.false = LaguerreRule.do(this.enum, precision);
    }

    private static double[] do(int a2) {
        Polynomial a3 = new LaguerrePolynomials().getPolynomial(a2);
        return GaussianQuadratureUtils.solveForEvaluationPointsFromPolynomial(a3);
    }

    @Override
    public double[] getCoefficients() {
        return Arrays.copyOf(this.false, this.false.length);
    }
}

