/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann.newtoncotes;

import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.IterativeIntegrator;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NewtonCotes
implements IterativeIntegrator {
    private int char = 1;
    private final double new;
    private final int const;
    private final int case;
    private double false;
    private final Type enum;

    @Override
    public double next(int iter, UnivariateRealFunction f, double a2, double b2, double sum0) {
        ArgumentAssertion.assertPositive(iter, "iteration count");
        double a3 = sum0;
        if (iter == 1) {
            this.false = b2 - a2;
            this.char = 1;
            switch (this.enum) {
                case CLOSED: {
                    a3 = 0.5 * this.false * (f.evaluate(a2) + f.evaluate(b2));
                    break;
                }
                case OPEN: {
                    a3 = this.false * f.evaluate((a2 + b2) / 2.0);
                }
            }
            return a3;
        }
        this.false /= (double)this.case;
        this.char *= this.case;
        double a4 = 0.0;
        double a5 = a2;
        for (int a6 = 1; a6 < this.char; ++a6) {
            a5 += this.false;
            if (a6 % this.case == 0) continue;
            a4 += f.evaluate(a5);
        }
        a3 = sum0 / (double)this.case + this.false * a4;
        return a3;
    }

    @Override
    public int getMaxIterations() {
        return this.const;
    }

    public NewtonCotes(int rate, Type type, double precision, int maxIterations) {
        this.case = rate;
        this.enum = type;
        this.new = precision;
        this.const = maxIterations;
    }

    @Override
    public double h() {
        return this.false;
    }

    @Override
    public double integrate(UnivariateRealFunction f, double a2, double b2) {
        double a3 = Double.NaN;
        for (int a4 = 1; a4 <= this.const; ++a4) {
            double a5 = a3;
            a3 = this.next(a4, f, a2, b2, a5);
            if (a4 > 3 && DoubleUtils.relativeError(a3, a5) < this.new) break;
        }
        return a3;
    }

    @Override
    public double getPrecision() {
        return this.new;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum Type {
        CLOSED,
        OPEN;


        private Type() {
            Type a2;
        }
    }
}

