/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann.newtoncotes;

import com.numericalmethod.suanshu.analysis.curvefit.interpolation.NevilleTable;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.tuple.PartialFunction;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.Integrator;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.IterativeIntegrator;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Romberg
implements Integrator {
    private final NevilleTable false;
    private IterativeIntegrator enum;

    public Romberg(IterativeIntegrator integrator) {
        ArgumentAssertion.assertNotLessThan(integrator.getMaxIterations(), 2, "the number of iterations");
        this.enum = integrator;
        this.false = new NevilleTable();
    }

    @Override
    public double integrate(UnivariateRealFunction f, double a2, double b2) {
        double a3 = 0.0;
        double a4 = 0.0;
        double a5 = 0.0;
        for (int a6 = 1; a6 <= this.enum.getMaxIterations(); ++a6) {
            a3 = this.enum.next(a6, f, a2, b2, a3);
            double a7 = this.enum.h();
            a5 = this.do(a7, a3);
            a4 = this.do();
            if (a6 > 3 && DoubleUtils.relativeError(a5, a4) < this.getPrecision()) break;
        }
        return a5;
    }

    private double do() {
        Romberg a2;
        int a3 = a2.false.N();
        double a4 = Double.NaN;
        if (a3 >= 2) {
            a4 = a2.false.get(0, a3 - 2);
        }
        return a4;
    }

    @Override
    public double getPrecision() {
        return this.enum.getPrecision();
    }

    private double do(double a2, double a3) {
        Romberg a4;
        a4.false.addData(new PartialFunction(new double[]{a2}, new double[]{a3}));
        double a5 = Double.NaN;
        if (a4.false.N() >= 2) {
            a5 = a4.false.evaluate(0.0);
        }
        return a5;
    }
}

