/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann.newtoncotes;

import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.IterativeIntegrator;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.newtoncotes.Trapezoidal;
import com.numericalmethod.suanshu.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Simpson
implements IterativeIntegrator {
    private final int new;
    private final double const;
    private double case;
    private final Trapezoidal false;
    private double enum;

    public Simpson(double precision, int maxIterations) {
        this.false = new Trapezoidal(precision, maxIterations);
        this.new = maxIterations;
        this.const = precision;
    }

    @Override
    public int getMaxIterations() {
        return this.new;
    }

    @Override
    public double next(int iteration, UnivariateRealFunction f, double a2, double b2, double sum) {
        if (iteration == 1) {
            this.enum = this.false.next(1, f, a2, b2, sum);
            this.case = this.false.next(2, f, a2, b2, this.enum);
        } else {
            this.enum = this.case;
            this.case = this.false.next(iteration + 1, f, a2, b2, this.enum);
        }
        double a3 = (4.0 * this.case - this.enum) / 3.0;
        return a3;
    }

    @Override
    public double getPrecision() {
        return this.const;
    }

    @Override
    public double integrate(UnivariateRealFunction f, double a2, double b2) {
        double a3 = Double.NaN;
        double a4 = Double.NaN;
        for (int a5 = 1; a5 <= this.new; ++a5) {
            a3 = a4;
            a4 = this.next(a5, f, a2, b2, a3);
            if (a5 > 3 && DoubleUtils.relativeError(a4, a3) < this.const) break;
        }
        return a4;
    }

    @Override
    public double h() {
        return this.false.h();
    }
}

