/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.geometry;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.geometry.Point;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LineSegment {
    private final Point false;
    private final Point enum;

    public double perpendicularDistance(Point p) {
        this.do(p);
        if (this.length() == 0.0) {
            return p.distance(this.enum);
        }
        Vector a2 = this.enum.getCoordinates().minus(p.getCoordinates());
        Vector a3 = this.false.getCoordinates().minus(this.enum.getCoordinates());
        a3 = a3.scaled(1.0 / a3.norm());
        Vector a4 = a3.scaled(a2.innerProduct(a3));
        Vector a5 = a2.minus(a4);
        return a5.norm();
    }

    public double distance(Point p) {
        this.do(p);
        double a2 = this.length();
        if (a2 == 0.0) {
            return p.distance(this.enum);
        }
        ImmutableVector a3 = this.enum.getCoordinates();
        ImmutableVector a4 = this.false.getCoordinates();
        ImmutableVector a5 = p.getCoordinates();
        Vector a6 = a4.minus(a3);
        double a7 = a5.minus(a3).innerProduct(a6) / (a2 * a2);
        if (a7 < 0.0) {
            return p.distance(this.enum);
        }
        if (a7 > 1.0) {
            return p.distance(this.false);
        }
        Point a8 = new Point(a3.add(a6.scaled(a7)));
        return p.distance(a8);
    }

    public Point getEndPoint1() {
        return this.enum;
    }

    public double length() {
        return this.enum.distance(this.false);
    }

    public int dimension() {
        return this.enum.dimension();
    }

    public LineSegment(Point p1, Point p2) {
        ArgumentAssertion.assertTrue(p1.dimension() == p2.dimension(), "dimensions of p1(%d) and p2(%d) must match", p1.dimension(), p2.dimension());
        this.enum = p1;
        this.false = p2;
    }

    private void do(Point a2) {
        LineSegment a3;
        ArgumentAssertion.assertTrue(a2.dimension() == a3.dimension(), "dimensions of the point(%d) and the line segment(%d) must match", a2.dimension(), a3.dimension());
    }

    public Point getEndPoint2() {
        return this.false;
    }

    static {
        Package.validate("BASIC");
    }
}

