/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.grid.executor.remote.akka;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.UntypedActorFactory;
import com.numericalmethod.suanshu.grid.config.remote.RemoteConfiguration;
import com.numericalmethod.suanshu.grid.executor.remote.akka.actor.FailureDetector;
import com.numericalmethod.suanshu.grid.executor.remote.akka.actor.Master;
import com.numericalmethod.suanshu.grid.executor.remote.akka.actor.OrderedAccumulator;
import com.numericalmethod.suanshu.grid.executor.remote.akka.actor.Slave;

public final class ActorProps {
    private static final long case = Long.MAX_VALUE;
    private static final int false = 0;
    private static final long enum = Long.MAX_VALUE;

    public static Props orderedAccumulatorProps(final int nResults) {
        return new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = -1648025270925993690L;
            {
                1 a2;
            }

            public Actor create() throws Exception {
                return new OrderedAccumulator(nResults);
            }
        });
    }

    public static Master.MasterAwareProps defaultFailureDetectorProps() {
        return new Master.MasterAwareProps(){

            @Override
            public Props props(final ActorRef master) {
                return new Props(new UntypedActorFactory(){
                    private static final long serialVersionUID = -4090637767321373818L;
                    {
                        1 a2;
                    }

                    public Actor create() throws Exception {
                        return new FailureDetector(master, Long.MAX_VALUE, Long.MAX_VALUE, 0);
                    }
                });
            }
            {
                3 a2;
            }
        };
    }

    private ActorProps() {
        ActorProps a2;
    }

    public static Master.MasterAwareProps failureDetectorProps(RemoteConfiguration config) {
        final RemoteConfiguration.FailureDetectionConfiguration a2 = config.failureDetectionConfiguration();
        if (a2 != null && !config.repeatable()) {
            return new Master.MasterAwareProps(){

                @Override
                public Props props(final ActorRef master) {
                    return new Props(new UntypedActorFactory(){
                        private static final long serialVersionUID = -4090637767321373818L;

                        public Actor create() throws Exception {
                            return new FailureDetector(master, a2.timeoutScanIntervalMillis(), a2.timeoutMillis(), a2.maximumRetries());
                        }
                        {
                            1 a2;
                        }
                    });
                }
                {
                    2 a22;
                }
            };
        }
        return ActorProps.defaultFailureDetectorProps();
    }

    public static Props slaveProps(final int nWorkers) {
        return new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 3586408551920293957L;
            {
                4 a2;
            }

            public Actor create() throws Exception {
                return new Slave(nWorkers);
            }
        });
    }
}

