/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.misc;

import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.ScientificNotation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Constants {
    public static final double EULER_MASCHERONI = 0.5772156649015329;
    public static final double EPSILON;
    public static final double APERY = 1.2020569031595942;
    public static final double GOLDEN_RATIO;
    public static final double ROOT_2_PI;
    public static final double MACH_EPS;
    public static final double PI_SQ = Math.PI * Math.PI;
    public static final double ROOT_PI;
    public static final int MACH_SCALE;
    public static final double ROOT_2;

    public static double unitRoundOff() {
        return Constants.unitRoundOff(10, 56);
    }

    public static double unitRoundOff(int base, int precision) {
        return 0.5 * Math.pow(base, 1 - precision);
    }

    static {
        Package.validate("BASIC");
        MACH_EPS = Constants.do();
        MACH_SCALE = Math.abs(new ScientificNotation(MACH_EPS).exponent()) + 1;
        EPSILON = Math.pow(10.0, new ScientificNotation(MACH_EPS).exponent() + 1);
        ROOT_2 = Math.sqrt(2.0);
        ROOT_2_PI = Math.sqrt(Math.PI * 2);
        ROOT_PI = Math.sqrt(Math.PI);
        GOLDEN_RATIO = (Math.sqrt(5.0) + 1.0) / 2.0;
    }

    private static double do() {
        double a2 = 1.0;
        while (1.0 + (a2 /= 2.0) / 2.0 != 1.0) {
        }
        return a2;
    }

    private Constants() {
        Constants a2;
    }
}

