/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.misc.datastructure;

import com.numericalmethod.suanshu.algebra.linear.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.algebra.linear.matrix.MatrixMismatchException;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.misc.datastructure.Table;

public class DimensionCheck {
    public static void throwIfInvalidColumn(Table A2, int j2) {
        if (j2 < 1 || j2 > A2.nCols()) {
            throw new MatrixAccessException(String.format("out of range [1:%d] column index: %d", A2.nCols(), j2));
        }
    }

    private DimensionCheck() {
        DimensionCheck a2;
    }

    public static boolean isSquare(Table A2) {
        return A2.nRows() == A2.nCols();
    }

    public static void throwIfIncompatible4Multiplication(Table A1, Table A2) {
        if (A1.nCols() != A2.nRows()) {
            throw new MatrixMismatchException(String.format("matrix with %d columns and matrix with %d rows cannot multiply due to mis-matched dimension", A1.nCols(), A2.nRows()));
        }
    }

    public static void throwIfIncompatible4Multiplication(Table A2, Vector v) {
        if (A2.nCols() != v.size()) {
            throw new MatrixMismatchException(String.format("matrix with %d columns and vector with %d elements cannot multiply due to mis-matched dimension", A2.nCols(), v.size()));
        }
    }

    public static void throwIfInvalidRow(Table A2, int i) {
        if (i < 1 || i > A2.nRows()) {
            throw new MatrixAccessException(String.format("out of range [1:%d] row index: %d", A2.nRows(), i));
        }
    }

    public static void throwIfDifferentDimension(Table A1, Table A2) {
        if (!DimensionCheck.isSameDimension(A1, A2)) {
            throw new MatrixMismatchException("tables do not have the same dimension");
        }
    }

    public static boolean isColumn(Table A2) {
        return A2.nCols() == 1;
    }

    public static boolean isFat(Table A2) {
        return A2.nCols() >= A2.nRows();
    }

    public static boolean isTall(Table A2) {
        return A2.nRows() >= A2.nCols();
    }

    public static boolean isSameDimension(Table A1, Table A2) {
        return A1.nRows() == A2.nRows() && A1.nCols() == A2.nCols();
    }

    public static boolean isRow(Table A2) {
        return A2.nRows() == 1;
    }

    public static boolean isArray(Table A2) {
        return A2.nCols() == 1 || A2.nRows() == 1;
    }
}

