/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.misc.datastructure;

import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.Constants;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MathTable {
    private final TreeMap<Double, Row> case;
    private final double false = 10.0 * Constants.EPSILON;
    private final Map<String, Integer> enum = new LinkedHashMap<String, Integer>();

    public void addRow(double index, double[] values) {
        Row a2 = new Row(index, values);
        this.case.put(a2.enum, a2);
    }

    public double get(double i, String header) {
        return this.get(i, this.enum.get(header));
    }

    static {
        Package.validate("BASIC");
    }

    public Iterator<Row> getRowsOnOrBefore(double i) {
        NavigableMap<Double, Row> a2 = this.case.headMap(i + this.false, true);
        NavigableMap<Double, Row> a3 = a2.descendingMap();
        Collection a4 = a3.values();
        return a4.iterator();
    }

    public MathTable(int nColumns) {
        this(MathTable.do(nColumns));
    }

    private static String[] do(int a2) {
        String[] a3 = new String[a2];
        for (int a4 = 1; a4 <= a2; ++a4) {
            a3[a4 - 1] = String.format("Column%d", a4);
        }
        return a3;
    }

    public MathTable(String ... headers) {
        this.case = new TreeMap();
        int a2 = 0;
        for (String a3 : headers) {
            this.enum.put(a3, a2++);
        }
        ArgumentAssertion.assertTrue(this.enum.size() == headers.length, "duplicated headers", new Object[0]);
    }

    public void addRows(double[][] data) {
        for (int a2 = 0; a2 < data.length; ++a2) {
            double[] a3 = data[a2];
            double a4 = a3[0];
            double[] a5 = Arrays.copyOfRange(a3, 1, a3.length);
            this.addRow(a4, a5);
        }
    }

    public Row getRowOnOrBefore(double i) {
        double a2 = this.case.headMap(i + this.false).lastKey();
        return this.case.get(a2);
    }

    public double[] getIndices() {
        NavigableSet<Double> a2 = this.case.navigableKeySet();
        return DoubleUtils.collection2DoubleArray(a2);
    }

    public double get(double i, int j2) {
        Row a2 = this.getRowOnOrBefore(i);
        double a3 = a2.enum;
        double a4 = a2.get(j2);
        if (a3 == i) {
            return a4;
        }
        Row a5 = this.getRowOnOrAfter(i);
        double a6 = a5.enum;
        double a7 = a5.get(j2);
        double a8 = a4 * (a6 - i);
        a8 += a7 * (i - a3);
        return a8 /= a6 - a3;
    }

    public String[] getHeaders() {
        return this.enum.keySet().toArray(new String[0]);
    }

    public Row getRowOnOrAfter(double i) {
        double a2 = this.case.tailMap(i - this.false).firstKey();
        return this.case.get(a2);
    }

    public int nColumns() {
        return this.enum.size();
    }

    public Iterator<Row> getRowsOnOrAfter(double i) {
        NavigableMap<Double, Row> a2 = this.case.tailMap(i - this.false, true);
        Collection a3 = a2.values();
        return a3.iterator();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Row {
        private final double[] false;
        private final double enum;

        public double[] toArray() {
            return Arrays.copyOf(this.false, this.false.length);
        }

        public double get(int j2) {
            return this.false[j2 - 1];
        }

        private Row(double a2, double[] a3) {
            Row a4;
            a4.enum = a2;
            a4.false = Arrays.copyOf(a3, a3.length);
        }

        public double get(String header) {
            return this.get((Integer)MathTable.this.enum.get(header));
        }
    }
}

