/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.multivariate.constrained.constraint;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.constraint.Constraints;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.constraint.EqualityConstraints;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.constraint.GreaterThanConstraints;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.constraint.LessThanConstraints;
import java.util.List;

public final class ConstraintsUtils {
    public static boolean isSatisfied(Constraints constraints, Vector x) {
        double a2 = PrecisionUtils.autoEpsilon(x.toArray());
        return ConstraintsUtils.isSatisfied(constraints, x, a2);
    }

    public static Vector evaluate(Constraints constraints, Vector x) {
        List<RealScalarFunction> a2 = constraints.getConstraints();
        DenseVector a3 = new DenseVector(a2.size());
        for (int a4 = 0; a4 < a2.size(); ++a4) {
            a3.set(a4 + 1, (Double)a2.get(a4).evaluate(x));
        }
        return a3;
    }

    public static boolean isSatisfied(Constraints constraints, Vector x, double epsilon) {
        Vector a2 = ConstraintsUtils.evaluate(constraints, x);
        if (EqualityConstraints.class.isAssignableFrom(constraints.getClass())) {
            return DoubleUtils.compare(a2.norm(), 0.0, epsilon) == 0;
        }
        if (GreaterThanConstraints.class.isAssignableFrom(constraints.getClass())) {
            for (int a3 = 1; a3 <= a2.size(); ++a3) {
                if (!(a2.get(a3) < -epsilon)) continue;
                return false;
            }
            return true;
        }
        if (LessThanConstraints.class.isAssignableFrom(constraints.getClass())) {
            for (int a4 = 1; a4 <= a2.size(); ++a4) {
                if (!(a2.get(a4) > epsilon)) continue;
                return false;
            }
            return true;
        }
        throw new RuntimeException("unrecognized constraint type");
    }
}

