/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.multivariate.constrained.constraint.linear;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixFactory;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.interval.RealInterval;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.constraint.LessThanConstraints;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.constraint.linear.LinearConstraints;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.constraint.linear.LinearGreaterThanConstraints;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.constraint.linear.LinearLessThanConstraints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BoxConstraints {
    private final List<Bound> false;
    private final int enum;

    public Vector lowerBounds() {
        DenseVector a2 = new DenseVector(this.enum, Double.NEGATIVE_INFINITY);
        for (Bound a3 : this.false) {
            a2.set(a3.index, a3.lower());
        }
        return a2;
    }

    public BoxConstraints(int dim, Bound ... bounds) {
        this.enum = dim;
        this.false = new ArrayList<Bound>(bounds.length);
        this.false.addAll(Arrays.asList(bounds));
        Collections.sort(this.false);
    }

    public Vector upperBounds() {
        DenseVector a2 = new DenseVector(this.enum, Double.POSITIVE_INFINITY);
        for (Bound a3 : this.false) {
            a2.set(a3.index, a3.upper());
        }
        return a2;
    }

    public List<Bound> bounds() {
        ArrayList<Bound> a2 = new ArrayList<Bound>(this.false.size());
        a2.addAll(this.false);
        return a2;
    }

    public LinearGreaterThanConstraints lowerBoundConstraints() {
        ArrayList<DenseVector> a3 = new ArrayList<DenseVector>();
        ArrayList<Double> a4 = new ArrayList<Double>();
        for (Bound bound : this.false) {
            Double a5 = bound.lower();
            if (a5 == Double.NEGATIVE_INFINITY || a5 == 0.0) continue;
            a4.add(a5);
            DenseVector a6 = new DenseVector(this.enum, 0.0);
            a6.set(bound.index, 1.0);
            a3.add(a6);
        }
        if (a3.isEmpty()) {
            return null;
        }
        Matrix a2 = MatrixFactory.rbind(a3.toArray(new Vector[0]));
        DenseVector denseVector = new DenseVector(DoubleUtils.collection2DoubleArray(a4));
        return new LinearGreaterThanConstraints(a2, denseVector);
    }

    public LinearLessThanConstraints upperBoundConstraints() {
        ArrayList<DenseVector> a3 = new ArrayList<DenseVector>();
        ArrayList<Double> a4 = new ArrayList<Double>();
        for (Bound bound : this.false) {
            Double a5 = bound.upper();
            if (a5 == Double.POSITIVE_INFINITY) continue;
            a4.add(a5);
            DenseVector a6 = new DenseVector(this.enum, 0.0);
            a6.set(bound.index, 1.0);
            a3.add(a6);
        }
        if (a3.isEmpty()) {
            return null;
        }
        Matrix a2 = MatrixFactory.rbind(a3.toArray(new Vector[0]));
        DenseVector denseVector = new DenseVector(DoubleUtils.collection2DoubleArray(a4));
        return new LinearLessThanConstraints(a2, denseVector);
    }

    public LinearGreaterThanConstraints toGreaterThanConstraints() {
        LinearLessThanConstraints a2 = this.toLessThanConstraints();
        LinearGreaterThanConstraints a3 = a2.toGreaterThanConstraints();
        return a3;
    }

    public static boolean isInBox(Vector x, Vector lower, Vector upper) {
        for (int a2 = 1; a2 <= x.size(); ++a2) {
            double a3 = x.get(a2);
            if (!(a3 < lower.get(a2)) && !(a3 > upper.get(a2))) continue;
            return false;
        }
        return true;
    }

    public BoxConstraints(Vector lower, Vector upper) {
        ArgumentAssertion.assertEqual(lower.size(), upper.size(), "the lower and upper bounds must have the same dimension");
        this.enum = lower.size();
        this.false = new ArrayList<Bound>(this.enum);
        for (int a2 = 1; a2 <= this.enum; ++a2) {
            double a3 = lower.get(a2);
            double a4 = upper.get(a2);
            if (Double.NEGATIVE_INFINITY == a3 && Double.POSITIVE_INFINITY == a4) continue;
            Bound a5 = new Bound(a2, a3, a4);
            this.false.add(a5);
        }
    }

    public LinearLessThanConstraints toLessThanConstraints() {
        LinearGreaterThanConstraints a2 = this.lowerBoundConstraints();
        LinearLessThanConstraints a3 = this.upperBoundConstraints();
        LessThanConstraints a4 = a2.toLessThanConstraints();
        LinearLessThanConstraints a5 = (LinearLessThanConstraints)LinearConstraints.concat(new LinearConstraints[]{a3, a4});
        return a5;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Bound
    implements Comparable<Bound> {
        private RealInterval enum;
        public final int index;

        public double lower() {
            return (Double)this.enum.begin();
        }

        public double upper() {
            return (Double)this.enum.end();
        }

        public String toString() {
            return String.format("x[%d]: %s", this.index, this.enum.toString());
        }

        public Bound(int index, double lower, double upper) {
            this.index = index;
            this.enum = new RealInterval(lower, upper);
        }

        @Override
        public int compareTo(Bound that) {
            return this.index < that.index ? -1 : (this.index > that.index ? 1 : 0);
        }
    }
}

