/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.multivariate.constrained.constraint.linear;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixFactory;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.SubMatrixRef;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.operation.VectorFactory;
import com.numericalmethod.suanshu.analysis.function.rn2r1.AbstractRealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.constraint.Constraints;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.constraint.linear.LinearEqualityConstraints;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.constraint.linear.LinearGreaterThanConstraints;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.constraint.linear.LinearLessThanConstraints;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class LinearConstraints
implements Constraints {
    private final ImmutableMatrix false;
    private final ImmutableVector enum;

    @Override
    public int size() {
        return this.false.nRows();
    }

    public ImmutableMatrix A() {
        return this.false;
    }

    public String toString() {
        StringBuilder a2 = new StringBuilder();
        a2.append(this.A().toString());
        if (this.getClass() == LinearGreaterThanConstraints.class) {
            a2.append(">=");
        } else if (this.getClass() == LinearLessThanConstraints.class) {
            a2.append("<=");
        } else if (this.getClass() == LinearEqualityConstraints.class) {
            a2.append("=");
        } else {
            throw new RuntimeException("unrecognized LinearConstraints subclass");
        }
        a2.append("\n");
        a2.append(this.b().toString());
        return a2.toString();
    }

    public static LinearConstraints concat(LinearConstraints ... groups) {
        Matrix[] a2 = new Matrix[groups.length];
        Vector[] a3 = new Vector[groups.length];
        Class<?> a4 = null;
        for (int a5 = 0; a5 < groups.length; ++a5) {
            if (groups[a5] == null) continue;
            if (a4 == null) {
                a4 = groups[a5].getClass();
            } else {
                ArgumentAssertion.assertTrue(a4.isAssignableFrom(groups[a5].getClass()), "groups must all have the same constraint type", new Object[0]);
            }
            a2[a5] = groups[a5].A();
            a3[a5] = groups[a5].b();
        }
        Matrix a6 = MatrixFactory.rbind(a2);
        Vector a7 = VectorFactory.concat(a3);
        try {
            Constructor<?> a8 = a4.getConstructor(Matrix.class, Vector.class);
            LinearConstraints a9 = (LinearConstraints)a8.newInstance(a6, a7);
            return a9;
        }
        catch (Exception a10) {
            throw new RuntimeException(a10);
        }
    }

    public ImmutableVector b() {
        return this.enum;
    }

    @Override
    public int dimension() {
        return this.false.nCols();
    }

    public LinearConstraints(Matrix A2, Vector b2) {
        this.false = new ImmutableMatrix(A2);
        this.enum = new ImmutableVector(b2);
    }

    public ArrayList<Integer> getActiveRows(Vector x, double epsilon) {
        ArrayList<Integer> a2 = new ArrayList<Integer>();
        for (int a3 = 1; a3 <= this.false.nRows(); ++a3) {
            Vector a4 = this.false.getRow(a3);
            double a5 = a4.innerProduct(x) - this.enum.get(a3);
            if (!(Math.abs(a5) < epsilon)) continue;
            a2.add(a3);
        }
        return a2;
    }

    public Matrix getActiveConstraints(Vector x, double epsilon) {
        int[] a2 = DoubleUtils.collection2IntArray(this.getActiveRows(x, epsilon));
        int[] a3 = DoubleUtils.seq(1, this.false.nCols());
        SubMatrixRef a4 = new SubMatrixRef(this.false, a2, a3);
        return a4;
    }

    @Override
    public List<RealScalarFunction> getConstraints() {
        ArrayList<RealScalarFunction> a2 = new ArrayList<RealScalarFunction>();
        int a3 = 1;
        while (a3 <= this.false.nRows()) {
            final int a4 = a3++;
            AbstractRealScalarFunction a5 = new AbstractRealScalarFunction(this.false.nCols()){
                {
                    1 a3;
                    super(a2);
                }

                @Override
                public Double evaluate(Vector x) {
                    Vector a2 = LinearConstraints.this.false.getRow(a4);
                    double a3 = a2.innerProduct(x);
                    return a3 - LinearConstraints.this.enum.get(a4);
                }
            };
            a2.add(a5);
        }
        return a2;
    }
}

