/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.multivariate.constrained.convex.sdp.socp.qp;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.triangle.LDLt;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.BackwardSubstitution;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.ForwardSubstitution;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.SymmetricMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.operation.RealVectorSpace;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.operation.VectorFactory;
import com.numericalmethod.suanshu.analysis.function.rn2r1.QuadraticFunction;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.doublearray.DoubleArrayMath;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.constraint.linear.LinearEqualityConstraints;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.convex.sdp.socp.qp.QPInfeasible;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.convex.sdp.socp.qp.QPSolution;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.convex.sdp.socp.qp.problem.QPProblemOnlyEqualityConstraints;

public class QPSimpleMinimizer {
    static {
        Package.validate("OPTIM");
    }

    public static QPSolution solve(QuadraticFunction f, LinearEqualityConstraints equal) throws QPInfeasible {
        return QPSimpleMinimizer.solve(f, equal, PrecisionUtils.autoEpsilon(f.Hessian()));
    }

    public static QPSolution solve(QuadraticFunction f) throws QPInfeasible {
        return QPSimpleMinimizer.solve(f, PrecisionUtils.autoEpsilon(f.Hessian()));
    }

    public static QPSolution solve(QuadraticFunction f, LinearEqualityConstraints equal, double epsilon) throws QPInfeasible {
        QPProblemOnlyEqualityConstraints a2 = new QPProblemOnlyEqualityConstraints(f, equal);
        final QPSolution a3 = QPSimpleMinimizer.solve((QuadraticFunction)a2, epsilon);
        final ImmutableVector a4 = a2.getSolutionToOriginalProblem(a3.minimizer());
        return new QPSolution(){

            @Override
            public boolean isUnique() {
                return a3.isUnique();
            }

            @Override
            public ImmutableVector minimizer() {
                return new ImmutableVector(a4);
            }
            {
                2 a2;
            }
        };
    }

    public static QPSolution solve(QuadraticFunction f, final double epsilon) throws QPInfeasible {
        Object a2;
        ImmutableMatrix a3 = f.Hessian();
        ImmutableVector a4 = f.p();
        LDLt a5 = new LDLt(new SymmetricMatrix(a3));
        DiagonalMatrix a6 = a5.D();
        double[] a7 = VectorFactory.diagonal(a6).toArray();
        final double a8 = DoubleArrayMath.min(a7);
        ArgumentAssertion.assertFalse(DoubleUtils.isNegative(a8, epsilon), "the Hessian matrix is not positive (semi-)definite", new Object[0]);
        if (DoubleUtils.isZero(a8, epsilon) && !((RealVectorSpace)(a2 = new RealVectorSpace(a3, epsilon))).isSpanned(a4)) {
            throw new QPInfeasible();
        }
        a2 = a5.L();
        UpperTriangularMatrix a9 = a5.Lt();
        Vector a10 = new ForwardSubstitution().solve((LowerTriangularMatrix)a2, a4.scaled(-1.0));
        Vector a11 = a10.ZERO();
        for (int a12 = 1; a12 <= a11.size(); ++a12) {
            if (DoubleUtils.isZero(a6.get(a12, a12), epsilon)) {
                if (DoubleUtils.isZero(a10.get(a12), epsilon)) continue;
                throw new QPInfeasible();
            }
            a11.set(a12, a10.get(a12) / a6.get(a12, a12));
        }
        final Vector a13 = new BackwardSubstitution().solve(a9, a11);
        return new QPSolution(){

            @Override
            public boolean isUnique() {
                return !DoubleUtils.isZero(a8, epsilon);
            }

            @Override
            public ImmutableVector minimizer() {
                return new ImmutableVector(a13);
            }
            {
                1 a2;
            }
        };
    }
}

