/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.multivariate.constrained.convex.sdp.socp.qp.lp.simplex;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixTable;
import com.numericalmethod.suanshu.misc.datastructure.FlexibleTable;

public class JordanExchange
extends FlexibleTable {
    public JordanExchange(MatrixTable A2, int r, int s) {
        super(A2.nRows(), A2.nCols());
        int a2;
        double a3 = A2.get(r, s);
        if (a3 == 0.0) {
            throw new RuntimeException(String.format("zero pivot found at [%d, %d] (linear dependence detected)", r, s));
        }
        for (a2 = 1; a2 <= A2.nCols(); ++a2) {
            this.set(r, a2, -A2.get(r, a2) / a3);
        }
        for (a2 = 1; a2 <= A2.nRows(); ++a2) {
            this.set(a2, s, A2.get(a2, s) / a3);
        }
        this.set(r, s, 1.0 / a3);
        for (a2 = 1; a2 <= A2.nRows(); ++a2) {
            for (int a4 = 1; a4 <= A2.nCols(); ++a4) {
                if (a2 == r || a4 == s) continue;
                this.set(a2, a4, A2.get(a2, a4) - this.get(a2, s) * A2.get(r, a4));
            }
        }
    }

    public JordanExchange(FlexibleTable A2, int r, int s) {
        this((MatrixTable)A2, r, s);
        int a2;
        for (a2 = 1; a2 <= this.nRows(); ++a2) {
            this.renameRow(a2, A2.getRowLabel(a2));
        }
        for (a2 = 1; a2 <= this.nCols(); ++a2) {
            this.renameCol(a2, A2.getColLabel(a2));
        }
        Object a3 = this.getRowLabel(r);
        this.renameRow(r, this.getColLabel(s));
        this.renameCol(s, a3);
    }
}

