/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.multivariate.constrained.convex.sdp.socp.qp.lp.simplex.solution;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.convex.sdp.socp.qp.lp.simplex.SimplexTable;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.convex.sdp.socp.qp.lp.simplex.solution.LPSimplexMinimizer;

public class LPUnboundedMinimizer
implements LPSimplexMinimizer {
    protected final SimplexTable table;
    protected final int lambdaCol;

    public LPUnboundedMinimizer(SimplexTable table, int lambdaCol) {
        ArgumentAssertion.assertTrue(lambdaCol > 0, "this class reads only an unbounded solution, lambdaCol = %d", lambdaCol);
        this.lambdaCol = lambdaCol;
        this.table = new SimplexTable(table);
    }

    @Override
    public SimplexTable getResultantTableau() {
        return new SimplexTable(this.table);
    }

    @Override
    public double minimum() {
        return Double.NEGATIVE_INFINITY;
    }

    public ImmutableVector v() {
        DenseVector a2 = new DenseVector(this.table.getProblemSize(), 0.0);
        a2.set(((SimplexTable.Label)this.table.getColLabel((int)this.lambdaCol)).index, 1.0);
        for (int a3 = 1; a3 < this.table.nRows(); ++a3) {
            if (((SimplexTable.Label)this.table.getRowLabel((int)a3)).type != SimplexTable.LabelType.NON_BASIC) continue;
            a2.set(((SimplexTable.Label)this.table.getRowLabel((int)a3)).index, this.table.get(a3, this.lambdaCol));
        }
        return new ImmutableVector(a2);
    }

    @Override
    public ImmutableVector minimizer() {
        return this.table.minimizer();
    }
}

