/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.multivariate.unconstrained;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.analysis.function.matrix.RntoMatrix;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import com.numericalmethod.suanshu.misc.algorithm.iterative.IterativeMethod;
import com.numericalmethod.suanshu.optimization.Optimizer;
import com.numericalmethod.suanshu.optimization.multivariate.unconstrained.MultivariateMinimizer;
import com.numericalmethod.suanshu.optimization.multivariate.unconstrained.NelderMeadMinimizer;
import com.numericalmethod.suanshu.optimization.problem.C2OptimProblem;
import com.numericalmethod.suanshu.optimization.problem.C2OptimProblemImpl;
import com.numericalmethod.suanshu.optimization.problem.IterativeMinimizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultivariateMaximizer
implements Optimizer<C2OptimProblem, Solution> {
    private final MultivariateMinimizer<? extends IterativeMinimizer<Vector>> enum;

    public MultivariateMaximizer(double epsilon, int maxIterations) {
        this(new NelderMeadMinimizer(epsilon, maxIterations));
    }

    @Override
    public Solution solve(final C2OptimProblem problem) throws Exception {
        final IterativeMinimizer a2 = (IterativeMinimizer)this.enum.solve(new C2OptimProblemImpl(new RealScalarFunction(){

            @Override
            public Double evaluate(Vector x) {
                return -1.0 * (Double)problem.f().evaluate(x);
            }
            {
                1 a2;
            }

            @Override
            public int dimensionOfDomain() {
                return problem.f().dimensionOfDomain();
            }

            @Override
            public int dimensionOfRange() {
                return problem.f().dimensionOfRange();
            }
        }, new RealVectorFunction(){

            @Override
            public int dimensionOfDomain() {
                return problem.g().dimensionOfDomain();
            }
            {
                2 a2;
            }

            @Override
            public int dimensionOfRange() {
                return problem.g().dimensionOfRange();
            }

            @Override
            public Vector evaluate(Vector x) {
                return ((Vector)problem.g().evaluate(x)).scaled(-1.0);
            }
        }, new RntoMatrix(){
            {
                3 a2;
            }

            @Override
            public int dimensionOfDomain() {
                return problem.H().dimensionOfDomain();
            }

            @Override
            public int dimensionOfRange() {
                return problem.H().dimensionOfRange();
            }

            @Override
            public Matrix evaluate(Vector x) {
                return ((Matrix)problem.H().evaluate(x)).scaled(-1.0);
            }
        }));
        Solution a3 = new Solution(){

            public void setInitials(Vector ... initials) {
                a2.setInitials(initials);
            }

            @Override
            public ImmutableVector maximizer() {
                return new ImmutableVector((Vector)a2.minimizer());
            }

            @Override
            public Object step() throws Exception {
                return a2.step();
            }

            public Vector search(Vector ... initials) throws Exception {
                return a2.search(initials);
            }
            {
                4 a22;
            }

            @Override
            public double maximum() {
                return -a2.minimum();
            }
        };
        return a3;
    }

    public <T extends MultivariateMinimizer<? extends IterativeMinimizer<Vector>>> MultivariateMaximizer(T minimizer) {
        this.enum = minimizer;
    }

    public static interface Solution
    extends IterativeMethod<Vector> {
        public ImmutableVector maximizer();

        public double maximum();
    }
}

